;---------------------------------------------------------------------------
; Control Rod Level 1/2 Ground
[Statedef 1000]
type = S
movetype = A
physics = S
velset = 0,0
anim = 1000+1*(var(10)=2)
poweradd = 15
ctrl = 0
sprpriority = 1
facep2 = 1

[State 1000, Effect]
type = helper
trigger1 = animelemtime(8)=-2
helpertype = normal
name = "Shockwave"
ID = 21001
pos = 55,-60
postype = p1
stateno = 21001
ownpal = 1
facing = 1

[State 1000, Effect]
type = helper
trigger1 = animelemtime(8)=0
helpertype = normal
name = "Burst Shot Lv1"
ID = 21000+10*(var(10)=2)
pos = 55,-62
postype = p1
stateno = 21000
ownpal = 1
facing = 1
size.xscale = 0.5+0.5*(var(10)=2)
size.yscale = 0.5+0.5*(var(10)=2)

[State 1000, PSND]
type = playsnd
trigger1 = animelemtime(7)=0
value = 1000,0
channel = 0

[State 1000, PSND]
type = playsnd
trigger1 = animelemtime(8)=0
value = 1000,10

[State -2, FLAG RECOVERY FRAMES]
type = statetypeset
trigger1 = animelemtime(8)=2
movetype = I
ignorehitpause = 1
persistent = 0

[State 1000, VS]
type = varset
trigger1 = animelemtime(8)>=2
var(1)=1

[State 1000, CS]
type = ChangeState
trigger1 = animtime = 0
value = 0
ctrl = 1

;---------------------------------------------------------------------------
; Control Rod Level 3 Ground
[Statedef 1001]
type = S
movetype = A
physics = S
velset = 0,0
anim = 1002+0*floor(cond(var(57)=1,var(57):=0,1))
poweradd = 30
ctrl = 0
sprpriority = 1
facep2 = 1

[State 1000, Effect]
type = helper
trigger1 = animelemtime(8)=-2
helpertype = normal
name = "Shockwave"
ID = 21001
pos = 65,-60
postype = p1
stateno = 21001
ownpal = 1
facing = 1

[State 1000, Effect]
type = helper
trigger1 = animelemtime(8)=0
helpertype = normal
name = "Burst Shot Lv3"
ID = 21030
pos = 65,-62
postype = p1
stateno = 21030
ownpal = 1
facing = 1

[State 1000, Effect]
type = helper
trigger1 = animelemtime(8)=0
helpertype = normal
name = "Burst Shot Lv3"
ID = 21020
pos = 65,-62
postype = p1
stateno = 21010
ownpal = 1
facing = 1
size.xscale=1.0
size.yscale=2.0

[State 1000, PSND]
type = playsnd
trigger1 = animelemtime(7)=0
value = 1000,0
channel = 0

[State 1000, PSND]
type = playsnd
trigger1 = animelemtime(8)=0
value = 1000,10

[State -2, FLAG RECOVERY FRAMES]
type = statetypeset
trigger1 = animelemtime(23)=0
movetype = I
ignorehitpause = 1
persistent = 0

[State 1000, VS]
type = varset
trigger1 = animelemtime(8)>=2
var(1)=1

[State 1000, CS]
type = ChangeState
trigger1 = animtime = 0
value = 0
ctrl = 1

;---------------------------------------------------------------------------
; Control Rod Level 1/2 AntiAir
[Statedef 1005]
type = S
movetype = A
physics = S
velset = 0,0
anim = 1005+1*(var(10)=2)
poweradd = 15
ctrl = 0
sprpriority = 1
facep2 = 1

[State 1000, Effect]
type = helper
trigger1 = animelemtime(8)=-2
helpertype = normal
name = "Shockwave"
ID = 21001
pos = 45,-79
postype = p1
stateno = 21001
ownpal = 1
facing = 1

[State 1000, Effect]
type = helper
trigger1 = animelemtime(8)=0
helpertype = normal
name = "Burst Shot"
ID = 21000+10*(var(10)=2)
pos = 45,-79
postype = p1
stateno = 21000
ownpal = 1
facing = 1
size.xscale = 0.5+0.5*(var(10)=2)
size.yscale = 0.5+0.5*(var(10)=2)

[State 1000, PSND]
type = playsnd
trigger1 = animelemtime(7)=0
value = 1000,0
channel = 0

[State 1000, PSND]
type = playsnd
trigger1 = animelemtime(8)=0
value = 1000,10

[State -2, FLAG RECOVERY FRAMES]
type = statetypeset
trigger1 = animelemtime(8)=2
movetype = I
ignorehitpause = 1
persistent = 0

[State 1000, VS]
type = varset
trigger1 = animelemtime(8)>=2
var(1)=1

[State 1000, CS]
type = ChangeState
trigger1 = animtime = 0
value = 0
ctrl = 1

;---------------------------------------------------------------------------
; Control Rod Level 3 Antiair
[Statedef 1006]
type = S
movetype = A
physics = S
velset = 0,0
anim = 1007+0*floor(cond(var(57)=1,var(57):=0,1))
poweradd = 30
ctrl = 0
sprpriority = 1
facep2 = 1

[State 1000, Effect]
type = helper
trigger1 = animelemtime(8)=-2
helpertype = normal
name = "Shockwave"
ID = 21001
pos = 56,-79
postype = p1
stateno = 21001
ownpal = 1
facing = 1

[State 1000, Effect]
type = helper
trigger1 = animelemtime(8)=0
helpertype = normal
name = "Burst Shot Lv3"
ID = 21030
pos = 56,-79
postype = p1
stateno = 21030
ownpal = 1
facing = 1
[State 1000, Effect]
type = helper
trigger1 = animelemtime(8)=0
helpertype = normal
name = "Burst Shot Lv3"
ID = 21020
pos = 56,-79
postype = p1
stateno = 21010
ownpal = 1
facing = 1
size.xscale=1.0
size.yscale=2.0

[State 1000, PSND]
type = playsnd
trigger1 = animelemtime(7)=0
value = 1000,0
channel = 0

[State 1000, PSND]
type = playsnd
trigger1 = animelemtime(8)=0
value = 1000,10

[State -2, FLAG RECOVERY FRAMES]
type = statetypeset
trigger1 = animelemtime(23)=0
movetype = I
ignorehitpause = 1
persistent = 0

[State 1000, VS]
type = varset
trigger1 = animelemtime(8)>=2
var(1)=1

[State 1000, CS]
type = ChangeState
trigger1 = animtime = 0
value = 0
ctrl = 1

;---------------------------------------------------------------------------
; Control Rod Level 1/2 Air
[Statedef 1010]
type = A
movetype = A
physics = N
velset = 0,0
anim = 1010+1*(var(10)=2)
poweradd = 15
ctrl = 0
sprpriority = 1
facep2 = 0

[State 1000, Effect]
type = helper
trigger1 = animelemtime(8)=-2
helpertype = normal
name = "Shockwave"
ID = 21001
pos = 55,-60
postype = p1
stateno = 21001
ownpal = 1
facing = 1

[State 1000, Effect]
type = helper
trigger1 = animelemtime(8)=0
helpertype = normal
name = "Burst Shot Lv1"
ID = 21000+10*(var(10)=2)
pos = 55,-62
postype = p1
stateno = 21000
ownpal = 1
facing = 1
size.xscale = 0.5+0.5*(var(10)=2)
size.yscale = 0.5+0.5*(var(10)=2)

[State 1000, PSND]
type = playsnd
trigger1 = animelemtime(7)=0
value = 1000,0
channel = 0

[State 1000, PSND]
type = playsnd
trigger1 = animelemtime(8)=0
value = 1000,10

[State -2, FLAG RECOVERY FRAMES]
type = statetypeset
trigger1 = animelemtime(8)=2
movetype = I
ignorehitpause = 1
persistent = 0

[State 1000, VS]
type = varset
trigger1 = animelemtime(8)>=2
var(1)=1

[State 1000, CS]
type = veladd
trigger1 = anim=1010
trigger1 = animelemtime(17)>0
trigger2 = anim=1011
trigger2 = animelemtime(14)>0
y = 0.5

[State 1000, CS]
type = ChangeState
trigger1 = vel y > 0
trigger1 = pos y >= -(vel y)
value = 1020

;---------------------------------------------------------------------------
; Control Rod Level 3 Air
[Statedef 1011]
type = A
movetype = A
physics = N
velset = 0,0
anim = 1012+0*floor(cond(var(57)=1,var(57):=0,1))
poweradd = 30
ctrl = 0
sprpriority = 1
facep2 = 0

[State 1000, Effect]
type = helper
trigger1 = animelemtime(8)=-2
helpertype = normal
name = "Shockwave"
ID = 21001
pos = 65,-60
postype = p1
stateno = 21001
ownpal = 1
facing = 1

[State 1000, Effect]
type = helper
trigger1 = animelemtime(8)=0
helpertype = normal
name = "Burst Shot Lv3"
ID = 21030
pos = 65,-62
postype = p1
stateno = 21030
ownpal = 1
facing = 1
[State 1000, Effect]
type = helper
trigger1 = animelemtime(8)=0
helpertype = normal
name = "Burst Shot Lv3"
ID = 21020
pos = 65,-62
postype = p1
stateno = 21010
ownpal = 1
facing = 1
size.xscale=1.0
size.yscale=2.0

[State 1000, PSND]
type = playsnd
trigger1 = animelemtime(7)=0
value = 1000,0
channel = 0

[State 1000, PSND]
type = playsnd
trigger1 = animelemtime(8)=0
value = 1000,10

[State -2, FLAG RECOVERY FRAMES]
type = statetypeset
trigger1 = animelemtime(23)=0
movetype = I
ignorehitpause = 1
persistent = 0

[State 1000, VS]
type = varset
trigger1 = animelemtime(8)>=2
var(1)=1

[State 1000, CS]
type = veladd
trigger1 = animelemtime(24)>0
y = 0.5

[State 1000, CS]
type = ChangeState
trigger1 = vel y > 0
trigger1 = pos y >= -(vel y)
value = 1020

;---------------------------------------------------------------------------
; Control Rod Level 1/2 AntiGround
[Statedef 1015]
type = A
movetype = A
physics = N
velset = 0,0
anim = 1015+1*(var(10)=2)
poweradd = 15
ctrl = 0
sprpriority = 1
facep2 = 0

[State 1000, Effect]
type = helper
trigger1 = animelemtime(8)=-2
helpertype = normal
name = "Shockwave"
ID = 21001
pos = 40,-4
postype = p1
stateno = 21001
ownpal = 1
facing = 1

[State 1000, Effect]
type = helper
trigger1 = animelemtime(8)=0
helpertype = normal
name = "Burst Shot Lv1"
ID = 21000+10*(var(10)=2)
pos = 40,-4
postype = p1
stateno = 21000
ownpal = 1
facing = 1
size.xscale = 0.5+0.5*(var(10)=2)
size.yscale = 0.5+0.5*(var(10)=2)

[State 1000, PSND]
type = playsnd
trigger1 = animelemtime(7)=0
value = 1000,0
channel = 0

[State 1000, PSND]
type = playsnd
trigger1 = animelemtime(8)=0
value = 1000,10

[State -2, FLAG RECOVERY FRAMES]
type = statetypeset
trigger1 = animelemtime(8)=2
movetype = I
ignorehitpause = 1
persistent = 0

[State 1000, VS]
type = varset
trigger1 = animelemtime(8)>=2
var(1)=1

[State 1000, CS]
type = veladd
trigger1 = anim=1015
trigger1 = animelemtime(17)>0
trigger2 = anim=1016
trigger2 = animelemtime(14)>0
y = 0.5

[State 1000, CS]
type = ChangeState
trigger1 = vel y > 0
trigger1 = pos y >= -(vel y)
value = 1020

;---------------------------------------------------------------------------
; Control Rod Level 3 AntiGround
[Statedef 1016]
type = A
movetype = A
physics = N
velset = 0,0
anim = 1017+0*floor(cond(var(57)=1,var(57):=0,1))
poweradd = 30
ctrl = 0
sprpriority = 1
facep2 = 0

[State 1000, Effect]
type = helper
trigger1 = animelemtime(8)=-2
helpertype = normal
name = "Shockwave"
ID = 21001
pos = 40,-4
postype = p1
stateno = 21001
ownpal = 1
facing = 1

[State 1000, Effect]
type = helper
trigger1 = animelemtime(8)=0
helpertype = normal
name = "Burst Shot Lv3"
ID = 21030
pos = 40,-4
postype = p1
stateno = 21030
ownpal = 1
facing = 1
[State 1000, Effect]
type = helper
trigger1 = animelemtime(8)=0
helpertype = normal
name = "Burst Shot Lv3"
ID = 21020
pos = 40,-4
postype = p1
stateno = 21010
ownpal = 1
facing = 1
size.xscale=1.0
size.yscale=2.0

[State 1000, PSND]
type = playsnd
trigger1 = animelemtime(7)=0
value = 1000,0
channel = 0

[State 1000, PSND]
type = playsnd
trigger1 = animelemtime(8)=0
value = 1000,10

[State -2, FLAG RECOVERY FRAMES]
type = statetypeset
trigger1 = animelemtime(23)=0
movetype = I
ignorehitpause = 1
persistent = 0

[State 1000, VS]
type = varset
trigger1 = animelemtime(8)>=2
var(1)=1

[State 1000, CS]
type = veladd
trigger1 = animelemtime(24)>0
y = 0.5

[State 1000, CS]
type = ChangeState
trigger1 = vel y > 0
trigger1 = pos y >= -(vel y)
value = 1020

;---------------------------------------------------------------------------
; Jump Land
[Statedef 1020]
type = S
physics = S
ctrl = 0
anim = 47

[State 4010, Explod]
type = Explod
trigger1 = time=0
anim = 21002
ID = 21002
pos = 30,0
postype = p1
bindtime = 1
vel = 8,0
accel = -0.5,0.0
scale = 0.75,0.75
sprpriority = 5
ownpal = 1
supermovetime = 99
[State 4010, Explod]
type = Explod
trigger1 = time=0
anim = 21002
ID = 21002
pos = -30,0
postype = p1
bindtime = 1
vel = -8,0
accel = 0.5,0.0
scale = 0.75,0.75
sprpriority = 5
ownpal = 1
supermovetime = 99

[State 1020, PSND]
type = playsnd
trigger1 = time = 0
value = 40,1

[State 52, 1]
type = VelSet
trigger1 = Time = 0
y = 0

[State 52, 2]
type = PosSet
trigger1 = Time = 0
y = 0

[State 52, 3]
type = CtrlSet
trigger1 = Time = 3
value = 1

[State 52, 4]
type = VelSet
trigger1 = abs(vel x) < Const(movement.stand.friction.threshold)
x = 0

[State -2, FLAG RECOVERY FRAMES]
type = statetypeset
trigger1 = 1
movetype = I
ignorehitpause = 1
persistent = 0

[State 1000, VS]
type = varset
trigger1 = 1
var(1)=1

[State 52, 5]
type = ChangeState
trigger1 = animtime = 0
value = 0
ctrl = 1

;---------------------------------------------------------------------------
; Control Rod Level 1/2
[Statedef 21000]
type = A
movetype = A
physics = N
velset = 0,0
anim = 21000+10*(ishelper(21010))
poweradd = 0
ctrl = 0
sprpriority = 5

[State 21000, VS]
type = null
triggerall = time = 0
trigger1 = (root,stateno = [1000,1001])||(root,stateno = [1010,1011])
trigger1 = (var(12):=0)||1
trigger2 = (root,stateno = [1005,1006])
trigger2 = (var(12):=30)||1
trigger3 = (root,stateno = [1015,1016])
trigger3 = (var(12):=-45)||1

[State 0, AngleDraw]
type = AngleDraw
trigger1 = 1
value = var(12)
ignorehitpause = 1
;persistent = 

[State 21000, VS]
type = velset
trigger1 = 1
x = (5.0+5.0*(ishelper(21010)))*cos(var(12)*pi/180.0)
y = -(5.0+5.0*(ishelper(21010)))*sin(var(12)*pi/180.0)

[State 21000, ASS]
type = assertspecial
trigger1=1
flag=noshadow
ignorehitpause=1

[State 21000, Trans]
type = trans
trigger1=1
trans = addalpha
alpha = 256,256
ignorehitpause=1

[State 1010, NHB]
type = nothitby
trigger1 = 1
value = ,AA,AT
ignorehitpause = 1

[State 1010, HitOverride]
Type = HitOverride
Trigger1 = 1
Attr = SCA,AA,AP,AT
slot = 0
time = -1
Stateno = 21005
IgnoreHitPause = 1

[State Movehitoner]
type = VarSet
trigger1 = numenemy
var(31) = ifelse(movehit=1&&(enemynear,movereversed!=[1,2]),var(31)+1,0)
ignorehitpause = 1
[State Give 'em a lil' 40, taken from The_None]
type = parentVarSet
trigger1 = var(31) = [1,2]
trigger1 = numtarget
trigger1 = (target,statetype = A) || (target,statetype = L)
var(34) = root,var(34) | floor(exp(2*ln(2)) + 0.5) ;Flag the move if the move has hit in a juggle way.
ignorehitpause = 1
persistent = 0

[State 1010, HitDef]
type = Hitdef
triggerall = !((root,var(34))&floor(exp(2*ln(2)) + 0.5))
trigger1 = time
trigger1 = !movecontact && !movereversed
attr = S,SP
animtype = Hard
damage = ceil((50.0+30.0*ishelper(21010))*root,fvar(11)),10+6*ishelper(21010)
priority = 4,Hit
hitflag = MAF
guardflag = MA
pausetime = 0,6
sparkno = s8010+(random%2)
guard.sparkno = s8030
sparkxy = -10,0
hitsound = s1,2
guardsound = s2,0
ground.type = Low
ground.slidetime = 19
ground.hittime = 19
air.hittime = 19
guard.slidetime = 15
guard.hittime = 15
ground.velocity = -8.0,-5.5*ishelper(21010)
guard.velocity = -8.0
air.velocity = -8.0,-5.5
airguard.velocity = -8.0,-5.5
p1sprpriority=5
fall = 0+1*ishelper(21010)
air.fall = 1
fall.recover = 1
fall.recovertime = 120
getpower = 60+20*ishelper(21010),60+20*ishelper(21010)
givepower = 30+10*ishelper(21010),30+10*ishelper(21010)
ground.cornerpush.veloff = 0
guard.cornerpush.veloff = 0
air.cornerpush.veloff = 0

[State -2, FLAG RECOVERY FRAMES]
type = statetypeset
trigger1 = movecontact||movereversed
movetype = I
persistent = 0
ignorehitpause = 1

[State 200, Damage Dampen]
type = parentvarset
trigger1 = movehit
fvar(10) = (root,fvar(10))*0.85*cond(root,fvar(10)>=1.0,(root,fvar(30)),1.0)
ignorehitpause = 1
persistent = 0

[State 21100, CS]
type = changestate
trigger1 = movecontact||movereversed
trigger2 = frontedgedist < -100
value = 21005

;---------------------------------------------------------------------------
;Shockwave
[Statedef 21001]
type = A
movetype = I
physics = N
velset = 0,0
anim = 21001
poweradd = 0
ctrl = 0
sprpriority = 5

[State 21000, VS]
type = null
triggerall = time = 0
trigger1 = (root,stateno = [1000,1002])||(root,stateno = [1010,1012])
trigger1 = (var(12):=0)||1
trigger2 = (root,stateno = [1005,1007])
trigger2 = (var(12):=30)||1
trigger3 = (root,stateno = [1015,1017])
trigger3 = (var(12):=-45)||1

[State 21001, ASS]
type = AssertSpecial
trigger1 = 1
flag = noshadow
ignorehitpause = 1

[State 21001, NHB]
Type = NotHitBy
Trigger1 = 1
Value = SCA,AA,AP,AT
ignorehitpause = 1

[State 21001, Scale]
type = AngleDraw
trigger1 = 1
value = var(12)
scale = log(10,(1+time))/8.0,log(10,(1+time))
ignorehitpause = 1

[State 21001, Trans]
type = trans
trigger1 = 1
trans = addalpha
alpha = 256-floor(256.0*time/16.0),256
ignorehitpause=1

[State 21001, Zeeky]
type = DestroySelf
trigger1 = !animtime
ignorehitpause = 1

;-----------------------
; Control Rod Destroy
[Statedef 21005]
type = A
movetype = I
physics = N
sprpriority = 5
;velset = 0,0
movehitpersist = 1

[State 0, AngleDraw]
type = AngleDraw
trigger1 = 1
value = var(12)
ignorehitpause = 1

[State -2, P2 Safe Fall]
type = targetstate
triggerall = numtarget=1 ;Just to prevent Simul mode shenanigans
triggerall = target,pos y>=-20 && target,vel y>0
triggerall = target,alive && target,hitfall && target,gethitvar(fall.recover)
triggerall = target,stateno=5030 || target,stateno=5035 || target,stateno=5050 || target,stateno=5071
trigger1 = target,AILevel <= 0
trigger1 = target,command="recovery"
trigger2 = target,AILevel > 0
trigger2 = random%100 <= 10*ceil((target,AILevel)*(target,AILevel)/64.0)
value = 5205
ignorehitpause = 1

[State 1015, T]
type = trans
trigger1 = 1
trans = addalpha
alpha = 256-floor(256.0*time/16.0),256
ignorehitpause = 1

[State 1015, ASS]
type = assertspecial
trigger1 = 1
flag = noshadow
ignorehitpause = 1

[State 1015, NHB]
type = nothitby
trigger1 = 1
value = SCA,AA,AP,AT
ignorehitpause = 1

[State 1015, Destroyself]
type = changestate
trigger1 = time >= 16
value = 999

;---------------------------------------------------------------------------
; Control Rod Level 3
[Statedef 21010]
type = A
movetype = A
physics = N
velset = 0,0
anim = 21020+1*(root,stateno = [1005,1007])+2*(root,stateno = [1015,1017])
poweradd = 0
ctrl = 0
sprpriority = 5

[State 21000, VS]
type = null
triggerall = time = 0
trigger1 = (root,stateno = [1000,1002])||(root,stateno = [1010,1012])
trigger1 = (var(12):=0)||1
trigger2 = (root,stateno = [1005,1007])
trigger2 = (var(12):=30)||1
trigger3 = (root,stateno = [1015,1017])
trigger3 = (var(12):=-45)||1

[State 0, NotHitBy]
type = NotHitBy
trigger1 = 1
value = ,AA,AT
;value2 = S,NA
time = 1
;ignorehitpause = 
;persistent = 

[State 1010, HitOverride]
Type = HitOverride
Trigger1 = 1
Attr = SCA,AA,AP,AT
slot = 0
time = -1
Stateno = 21012
IgnoreHitPause = 1

[State 0, BindToRoot]
type = BindToRoot
trigger1 = (root,stateno = [1000,1002])||(root,stateno = [1010,1012])
facing = 1
pos = 65,-62
ignorehitpause = 1
[State 0, BindToRoot]
type = BindToRoot
trigger1 = (root,stateno = [1005,1007])
facing = 1
pos = 56,-79
ignorehitpause = 1
[State 0, BindToRoot]
type = BindToRoot
trigger1 = (root,stateno = [1015,1017])
facing = 1
pos = 40,-4
ignorehitpause = 1

[State 0, AngleDraw]
type = AngleDraw
trigger1 = 1
value = var(12)
ignorehitpause = 1

[State 21000, ASS]
type = assertspecial
trigger1=1
flag=noshadow
ignorehitpause=1

[State 21000, Trans]
type = trans
trigger1=1
trans = addalpha
alpha = 256,256
ignorehitpause=1

[State 21100, VS]
type = varset
trigger1 = time = 0
var(21) = 5

[State 21010, CS]
type = changestate
trigger1 = 1;time >= 27
value = 21011

;---------------------------------------------------------------------------
; Control Rod Level 3
[Statedef 21011]
type = A
movetype = A
physics = N
velset = 0,0
poweradd = 0
ctrl = 0
sprpriority = 5
movehitpersist=1

[State 0, NotHitBy]
type = NotHitBy
trigger1 = 1
value = ,AA,AT
;value2 = S,NA
time = 1
ignorehitpause = 1

[State 0, BindToRoot]
type = BindToRoot
trigger1 = (root,stateno = [1000,1002])||(root,stateno = [1010,1012])
facing = 1
pos = 65,-62
ignorehitpause = 1
[State 0, BindToRoot]
type = BindToRoot
trigger1 = (root,stateno = [1005,1007])
facing = 1
pos = 56,-79
ignorehitpause = 1
[State 0, BindToRoot]
type = BindToRoot
trigger1 = (root,stateno = [1015,1017])
facing = 1
pos = 40,-4
ignorehitpause = 1

[State 0, AngleDraw]
type = AngleDraw
trigger1 = 1
value = var(12)
ignorehitpause = 1

[State 21000, ASS]
type = assertspecial
trigger1=1
flag=noshadow
ignorehitpause=1

[State 21000, Trans]
type = trans
trigger1=1
trans = addalpha
alpha = 256,256
ignorehitpause=1

[State Movehitoner]
type = VarSet
trigger1 = numenemy
var(31) = ifelse(movehit=1&&(enemynear,movereversed!=[1,2]),var(31)+1,0)
ignorehitpause = 1
[State Give 'em a lil' 40, taken from The_None]
type = parentVarSet
trigger1 = var(31) = [1,2]
trigger1 = numtarget
trigger1 = (target,statetype = A) || (target,statetype = L)
var(34) = root,var(34) | floor(exp(2*ln(2)) + 0.5) ;Flag the move if the move has hit in a juggle way.
ignorehitpause = 1
persistent = 0

[State 21301, MHR]
type = movehitreset
trigger1 = var(20)=0
persistent = 0

[State 1010, HitDef]
type = Hitdef
triggerall = !((root,var(34))&floor(exp(2*ln(2)) + 0.5)) || var(21)<5;uniqhitcount
triggerall = anim!=21022
trigger1 = var(20)=0
trigger1 = time
trigger1 = !movecontact; && !movereversed
attr = S,SP
animtype = Hard
damage = ceil(22.0*(root,fvar(11)/cond(root,var(57)=1,(root,fvar(30)),1))),4
priority = 4,Hit
hitflag = MAF
guardflag = MA
pausetime = 0,9
sparkno = s8010+(random%2)
guard.sparkno = s8030
sparkxy = -10,floor(p2dist y)-50
hitsound = -1;s1,2
guardsound = -1;s2,0
ground.type = High
ground.slidetime = 19
ground.hittime = 19
air.hittime = 19
guard.slidetime = 11
guard.hittime = 11
ground.velocity = -6.0,-6.5
guard.velocity = -6.0
air.velocity = -6.0,-6.5
airguard.velocity = -6.0,-6.5
p1sprpriority=5
fall = 1
air.fall = 1
fall.recover = 1
fall.recovertime = 120
getpower = 18,18
givepower = 9,9
ground.cornerpush.veloff = 0
guard.cornerpush.veloff = 0
air.cornerpush.veloff = 0
id = 1020

[State 1010, HitDef]
type = Hitdef
triggerall = !((root,var(34))&floor(exp(2*ln(2)) + 0.5)) || var(21)<5;uniqhitcount
triggerall = anim=21022
trigger1 = var(20)=0
trigger1 = time
trigger1 = !movecontact && !movereversed
attr = S,SP
animtype = Hard
damage = ceil(22.0*(root,fvar(11)/cond(root,var(57)=1,(root,fvar(30)),1))),4
priority = 4,Hit
hitflag = MAFD
guardflag = MA
pausetime = 0,9
sparkno = s8010+(random%2)
guard.sparkno = s8030
sparkxy = -10,floor(p2dist y)-50
hitsound = -1;s1,2
guardsound = -1;s2,0
ground.type = High
ground.slidetime = 19
ground.hittime = 19
air.hittime = 19
guard.slidetime = 11
guard.hittime = 11
ground.velocity = -6.0,-6.5
guard.velocity = -6.0
air.velocity = -6.0,-6.5
airguard.velocity = -6.0,-6.5
p1sprpriority=5
fall = 1
air.fall = 1
fall.recover = 1
fall.recovertime = 120
getpower = 18,18
givepower = 9,9
ground.cornerpush.veloff = 0
guard.cornerpush.veloff = 0
air.cornerpush.veloff = 0
id = 1020

[State 220, First Combo Hit]
type = parentvarset
triggerall = numtarget(1020)
trigger1 = target(1020),gethitvar(hitcount)=1
trigger1 = root,var(57)=0
var(57) = 1;Change index
ignorehitpause = 1
persistent = 0

[State 200, Damage Dampen]
type = parentvarset
trigger1 = movehit
fvar(10) = (root,fvar(10))*0.96*cond(root,fvar(10)>=1.0,(root,fvar(30)),1.0)
ignorehitpause = 1
persistent = 0

[State 21300, Hitsound]
type = playsnd
trigger1 = movehit=1
value = 1,9
channel = 2

[State 21300, Hitsound]
type = playsnd
trigger1 = moveguarded=1
value = 2,0
channel = 2

[State 0, Hard Knockdown]
type = TargetState
trigger1 = p2statetype=A && movehit && (p2stateno!=[6020,6110])
value = 6020
ID = 1020
ignorehitpause = 1

[State 21301, Destroy]
type = changestate
trigger1 = var(20)=0
trigger1 = movecontact=1;||movereversed
value = 21012

[State 21301, Destroy]
type = changestate
trigger1 = var(12)=0
trigger1 = root,stateno != 1001 && root,stateno != 1011
trigger2 = var(12)=30
trigger2 = root,stateno != 1006
trigger3 = var(12)=-45
trigger3 = root,stateno != 1016
trigger4 = root,movetype = H
trigger5 = var(11) >= 39
value = 21015

[State 21301, Custom Timer]
type = varadd
trigger1 = 1
var(11) = 1

[State 21301, VA]
type = varadd
trigger1 = var(20)>0
var(20) = -1

[State 21010, CS]
type = changestate
trigger1 = time >= 39
value = 21015

;---------------------------------------------------------------------------
; Control Rod Lv3 Projectile
[Statedef 21012]
type = A
movetype = I
physics = N
velset = 0,0
sprpriority=5
ctrl = 0
movehitpersist = 1

[State 0, BindToRoot]
type = BindToRoot
trigger1 = (root,stateno = [1000,1002])||(root,stateno = [1010,1012])
facing = 1
pos = 65,-62
ignorehitpause = 1
[State 0, BindToRoot]
type = BindToRoot
trigger1 = (root,stateno = [1005,1007])
facing = 1
pos = 56,-79
ignorehitpause = 1
[State 0, BindToRoot]
type = BindToRoot
trigger1 = (root,stateno = [1015,1017])
facing = 1
pos = 40,-4
ignorehitpause = 1

[State 0, AngleDraw]
type = AngleDraw
trigger1 = 1
value = var(12)
ignorehitpause = 1

[State 1010, NHB]
type = nothitby
trigger1 = 1
value = SCA,AA,AP,AT
ignorehitpause = 1

[State 21302, Cooldown]
type = varset
trigger1 = time = 0
trigger1 = movecontact
var(20) = 7;4

[State 21302, Inc Counter]
type = varadd
trigger1 = time = 0
var(21) = -1

[State 21302, Inc Counter]
type = varadd
trigger1 = time = 0
var(40) = 1

[State 21000, ASS]
type = assertspecial
trigger1 = 1
flag = noshadow
ignorehitpause = 1

[State 21302, CS]
type = changestate
trigger1 = 1
value = ifelse(var(21)<=0,21015,21011)

;---------------------------------------------------------------------------
; Control Rod Level 3
[Statedef 21015]
type = A
movetype = I
physics = N
velset = 0,0
poweradd = 0
ctrl = 0
sprpriority = 5
movehitpersist = 1

[State 0, NotHitBy]
type = NotHitBy
trigger1 = 1
value = SCA,AA,AP,AT
;value2 = S,NA
time = 1
ignorehitpause = 1

[State 21011, Scale]
type = angledraw
trigger1 = 1
value = var(12)
scale = 1.0,1.0-(1.0*time/5.0)
ignorehitpause = 1

[State 21000, ASS]
type = assertspecial
trigger1=1
flag=noshadow
ignorehitpause=1

[State 21000, Trans]
type = trans
trigger1=1
trans = addalpha
alpha = 256,256
ignorehitpause=1

[State 21010, CS]
type = changestate
trigger1 = time >= 5
value = 999

;---------------------------------------------------------------------------
; Control Rod Level 3 FX2
[Statedef 21030]
type = A
movetype = I
physics = N
velset = 0,0
anim = 21030
poweradd = 0
ctrl = 0
sprpriority = 5

[State 0, BindToRoot]
type = BindToRoot
trigger1 = (root,stateno = [1000,1002])||(root,stateno = [1010,1012])
facing = 1
pos = 65,-62
ignorehitpause = 1
[State 0, BindToRoot]
type = BindToRoot
trigger1 = (root,stateno = [1005,1007])
facing = 1
pos = 56,-79
ignorehitpause = 1
[State 0, BindToRoot]
type = BindToRoot
trigger1 = (root,stateno = [1015,1017])
facing = 1
pos = 40,-4
ignorehitpause = 1

[State 1000]
Type = Helper
Trigger1 = 1
persistent=3
Name = "Effect2"
Stateno = 21032
ID = 21032
Pos = 0,0
PosType = P1
Ownpal = 1
Keyctrl = 0
IgnoreHitPause = 1

[State 1007, AssertSpecial]
type = AssertSpecial
trigger1 = 1
flag = noshadow
ignorehitpause = 1

[State 1007, Trans]
type = Trans
trigger1 = 1
trans = Add
ignorehitpause = 1

[State 1007, AngleDraw]
type = AngleDraw
trigger1 = 1;time = [0,36]
scale = 0.75,0.75
ignorehitpause = 1

[State 1007, AngleAdd]
type = AngleAdd
trigger1 = 1
value = 3

[State 1007, DestroySelf]
type = changestate;DestroySelf
trigger1 = Root,Movetype = H
;trigger2 = root,anim=1002||root,anim=1007||root,anim=1012||root,anim=1017
;trigger2 = root,animelemtime(22)>=0
trigger2 = time>=36
value = 21031

;---------------------------------------------------------------------------
; Control Rod Level 3 FX2
[Statedef 21031]
type = A
movetype = I
physics = N
velset = 0,0
anim = 21030
poweradd = 0
ctrl = 0
sprpriority = 5

[State 1007, AssertSpecial]
type = AssertSpecial
trigger1 = 1
flag = noshadow
ignorehitpause = 1

[State 1007, Trans]
type = Trans
trigger1 = 1
trans = Add
ignorehitpause = 1

[State 1007]
type = AngleDraw
trigger1 = 1
scale = 0.75-(0.75*time/5.0),0.75-(0.75*time/5.0)
ignorehitpause = 1

[State 1007, AngleAdd]
type = AngleAdd
trigger1 = 1
value = 3

[State 1007, DestroySelf]
type = DestroySelf
trigger1 = time>=5

;---------------------------------------------------------------------------
[StateDef 21032]
Type = A
Physics = N
Ctrl = 0
Anim = 21031
SprPriority = 5

[State 1011]
Type = Trans
Trigger1 = 1
Trans = Addalpha
alpha = 256,256

[State 1011, AssertSpecial]
Type = AssertSpecial
Trigger1 = 1
Flag = Noshadow
IgnoreHitPause = 1

[State 1011]
Type = VarRandom
Trigger1 = Time = 0
V = 18
Range = 0,360

[State 1011]
Type = VarRandom
Trigger1 = Time = 0
V = 19
Range = 10,20

[State 1011, VelSet]
Type = VelSet
Trigger1 = Time = 0
X = Cos(Var(18)*Pi/180.0)*Var(19)
Y = Sin(Var(18)*Pi/180.0)*-Var(19)

[State 1011]
Type = VarAdd
Trigger1 = 1
FV = 20
Value = 0.1

[State 1011, AngleDraw]
Type = AngleDraw
Trigger1 = 1
Scale = 1+FVar(20),1-FVar(20)

[State 1011, AngleSet]
Type = AngleSet
Trigger1 = (Vel X != 0)
Value = ATan(Vel Y/Vel X)*(-180.0/Pi)+((Vel X<0)*180)
IgnoreHitPause = 1

[State 1011]
Type = AngleSet
Trigger1 = (Vel X = 0)
Value = IfElse(Vel Y<0,90,-90)
IgnoreHitPause = 1

[State 1011]
Type = VarAdd
Trigger1 = 1
V = 2
Value = 25

[State 1011]
Type = VarSet
Trigger1 = Var(2) >= 256
V = 2
Value = 256

[State 1011]
Type = PalFx
Trigger1 = 1
Time = 1
Add = 0,0,0
Mul = 256-Var(2),256-Var(2),256-Var(2)

[State -1]
Type = DestroySelf
Trigger1 = Time >= 10
Trigger2 = Root,MoveType = H
trigger3 = Root,Stateno != [1000,1016]

;---------------------------------------------------------------------------
; Rocket Dive Charge
[Statedef 1100]
type = U
movetype = A
physics = N
velset = 0,0
anim = 1100+0*(var(13):=0)+0*(var(47):=0)+0*(var(18):=0)+0*(var(16):=0)
poweradd = 0
ctrl = 0
sprpriority = 1
facep2 = 0

[State 1100, NoGuard]
type = attackdist
trigger1 = time>=0
value = 0
ignorehitpause = 1

[State 1100, VS]
type = varset
trigger1 = time = 0
var(11) = floor(pos x)

[State 1100, Turn]
type = turn
trigger1 = time = 0
trigger1 = p2dist x < 0
trigger1 = statetype != A

[State 1100, STS]
type = statetypeset
trigger1 = time = 0
trigger1 = statetype != A
statetype = S

[State -3, PSND]
type = playsnd
trigger1 = time=0
value = 1100,10
channel = 4

[State 0, ModifyExplod]
type = Explod
trigger1 = animelemtime(4)>0
persistent=0
ID = 30000
anim = 30000
pos = -40,10
postype = p1
facing=1
bindtime = -1
removetime = -1
scale = 1,1
sprpriority = 4
ontop = 0
ownpal = 1
removeongethit = 1
[State 0, ModifyExplod]
type = Explod
trigger1 = animelemtime(4)>0
persistent=0
ID = 30001
anim = 30001
pos = -40,10
postype = p1
facing=1
bindtime = -1
removetime = -1
scale = 0.5,1
sprpriority = 5
ontop = 0
ownpal = 1
removeongethit = 1

[State 1100, VA]
type = varadd
triggerall = animelemtime(4)>0
triggerall = var(13)<70;90
trigger1 = var(10)<=1
trigger1 = command="holdx"||command="holdc"
trigger2 = var(10)=2
trigger2 = command="holdy"||command="holdb"||command="holdc"
trigger3 = var(10)>=3
trigger3 = command="holdz"||command="holdb"||command="holdc"
var(13)=1

[State 0, ModifyExplod]
type = ModifyExplod
trigger1 = animelemtime(4)>0
ID = 30001
scale = (1.0*var(13)/70.0),1.0

[State -3, PSND]
type = playsnd
triggerall = roundstate=2
trigger1 = var(13)=30
trigger1 = (var(47):=90)||1
trigger2 = var(13)=70
trigger2 = (var(47):=150)||1
value = 1000,11
channel = 6

[State -3, PSND]
type = playsnd
trigger1 = var(13)=70;90
value = 1010,10
channel = 7

[State 4010, Explod]
type = Explod
trigger1 = var(13)=30
trigger2 = var(13)=70;90
anim = 21002
ID = 21002
pos = 30,0
postype = p1
bindtime = 1
vel = 8,0
accel = -0.5,0.0
scale = 0.75,0.75
sprpriority = 5
ownpal = 1
supermovetime = 99
[State 4010, Explod]
type = Explod
trigger1 = var(13)=30
trigger2 = var(13)=70;90
anim = 21002
ID = 21002
pos = -30,0
postype = p1
bindtime = 1
vel = -8,0
accel = 0.5,0.0
scale = 0.75,0.75
sprpriority = 5
ownpal = 1
supermovetime = 99

[State 1100, VA]
type = changestate
triggerall = var(8)=0
triggerall = animelemtime(4)>0
triggerall = var(13)<70
trigger1 = command="22"
trigger1 = (var(10):=1)||1
trigger2 = command = "FF" || (command = "holdfwd" && command!="holdback" && (command="a"))
trigger2 = (var(10):=2)||1
trigger3 = command = "BB" || (command = "holdback" && command!="holdfwd" && (command="a"))
trigger3 = (var(10):=3)||1
value = cond(statetype=A,1121,1120)

[State 1100, CS]
type = changeanim
trigger1 = (var(10)<=1&&command!="holdx"&&command!="holdc")||(var(10)=2&&command!="holdy"&&command!="holdb"&&command!="holdc")||(var(10)>=3&&command!="holdz"&&command!="holdb"&&command!="holdc")
trigger1 = animelemtime(4)>=0
trigger2 = (var(10)<=1&&command="rlsx")||(var(10)=2&&command="rlsy")||(var(10)>=3&&command="rlsz")||(var(10)>=2&&command="rlsb")||(command="rlsc")
trigger2 = animelemtime(4)>0
trigger3 = animelemtime(4)>=70
value = 1101

[State 1100, PA]
type = poweradd
trigger1 = anim=1101
value = 30+15*(var(13)=70)
persistent = 0

[State 1100, CS]
type = changestate
trigger1 = anim = 1101
trigger1 = (var(17):=0)||1
value = 1101

;---------------------------------------------------------------------------
; Rocket Dive Active
[Statedef 1101]
type = A
movetype = A
physics = N
;velset = 0,0
ctrl = 0
sprpriority = 1
movehitpersist=1
juggle = 0

[State Give 'em a lil' 40, taken from The_None]
type = VarSet
trigger1 = var(31) = [1,2]
trigger1 = numtarget
trigger1 = (target,statetype = A) || (target,statetype = L)
var(34) = var(34) | floor(exp(3*ln(2)) + 0.5) ;Flag the move if the move has hit in a juggle way.
ignorehitpause = 1
persistent = 0

[State 1101, VS]
type = null
triggerall = time = 0
triggerall = prevstateno = 1100
trigger1 = var(10)<=1
trigger1 = (var(18):=100)||1
trigger2 = var(10)=2
trigger2 = (var(18):=110)||1
trigger3 = var(10)>=3
trigger3 = (var(18):=120)||1

[State 0, HitOverride]
type = HitOverride
trigger1 = var(13)=[30,69]
trigger1 = prevstateno!=1105
trigger2 = var(13)>=70;90
attr = SCA,AA,AP
slot = 0
stateno = 1105
time = 1
ignorehitpause = 1
;persistent = 

[State 1400, Armor Damage Reduction]
type = VarSet
trigger1 = 1;animelemtime(15)<0
fvar(8) = life
ignorehitpause = 1

[State 1201, PlayerPush]
type = PlayerPush
trigger1 = 1
value = 0

[State 0, RemoveExplod]
type = RemoveExplod
trigger1 = animelemtime(1)=0
trigger1 = var(13)>=70;90
id = 30001

[State 0, ModifyExplod]
type = Explod
trigger1 = animelemtime(1)=0
trigger1 = var(13)>=70;90
persistent=0
ID = 30001
anim = 30002
pos = -40,10
postype = p1
facing=1
bindtime = -1
removetime = -1
scale = 1.0,1
sprpriority = 5
ontop = 0
ownpal = 1
removeongethit = 1

[State 1101, Wing1]
type = helper
trigger1 = AnimElemtime(2)=0
ID = 21100
stateno = 21100
Name = "Thruster"
ownpal = 1
[State 1101, Wing2]
type = helper
trigger1 = AnimElemtime(2)=0
ID = 21101
stateno = 21100
Name = "Thruster"
ownpal = 1

[State -3, PSND]
type = playsnd
trigger1 = animelemtime(1)=0
value = 1100,0
channel = 0

[State -3, PSND]
type = playsnd
trigger1 = animelemtime(1)=0
value = 1100,11
channel = 4

[State 1101, VS]
type = velset
trigger1 = animelemtime(2)=0
x = 0.25;0.25*(var(10)=2)+0.5*(var(10)>=3)

[State 1101, Accel]
type = veladd
trigger1 = animelemtime(2)>0
x = 0.3+0.4*(var(10)=2)+0.6*(var(10)>=3)

[State 0, ScreenBound]
type = ScreenBound
trigger1 = 1
value = 0
movecamera = 0,1
ignorehitpause = 1

[State 1101, Damage Set]
type = null
trigger1 = time = 0
trigger1 = (var(6):=(var(18)+floor(var(18)*0.5)*(var(13)>=30)+floor(var(18)*0.5)*(var(13)>=70)))||1
trigger1 = (var(7):=(ceil(var(18)*0.2)+ceil(var(18)*0.5*0.2)*(var(13)>=30)+ceil(var(18)*0.5*0.2)*(var(13)>=70)))||1

[State 1101, Hitdef]
type = HitDef
trigger1 = ifelse((var(34)&floor(exp(3*ln(2)) + 0.5)),0,1)
trigger1 = time
;trigger1 = !movecontact && !movereversed
trigger1 = var(17)=0
attr = A,SA
damage = ceil(var(6)*fvar(11)*ifelse(var(42),1.25,1.0)),var(7)                   ;Damage that move inflicts, guard damage
animtype = Heavy
guardflag = HA
hitflag = MAF
priority = 4,Hit
pausetime = 10,10
sparkno = S8020+(random%2)
guard.sparkno = S8030
sparkxy = -20,-70
hitsound = s1,2
guardsound = s2,0
ground.type = High
ground.slidetime = 24+3*(var(42))
ground.hittime = 24+3*(var(42))
air.hittime = 24+3*(var(42))
guard.slidetime = 18
guard.hittime = 18
ground.velocity = -2.5,-15.0
air.type = High
air.velocity = -2.5,-15.0
getpower = 80,80
givepower = 40,40
ground.cornerpush.veloff = 0
guard.cornerpush.veloff = 0
air.cornerpush.veloff = 0
yaccel = 0.5
fall = 1
air.fall = 1
fall.recover = cond((var(13)>=70),0,1);1
fall.recovertime = cond((var(13)>=70),999999,120)
p2facing = 1
id = 1100

[State 0, VarSet]
type = VarSet
trigger1 = movecontact
trigger1 = var(17)=0
var(17)=1
ignorehitpause=1
persistent=0 

[State 0, Hard Knockdown]
type = TargetState
trigger1 = (var(13)>=70)
trigger1 = p2statetype=A && (movehit=1) && (p2stateno!=[6020,6110])
value = 6020
ID = 1100
ignorehitpause = 1

[State 200, Damage Dampen]
type = varset
trigger1 = movehit
fvar(10) = fvar(10)*0.8*cond(fvar(10)>=1.0,(fvar(30)),1.0)
ignorehitpause = 1
persistent = 0

[State -2, FLAG RECOVERY FRAMES]
type = statetypeset
trigger1 = teammode != simul
trigger1 = moveguarded||movereversed
movetype = I
ignorehitpause = 1
persistent = 0

[State 1101, CS]
Type = ChangeState
trigger1 = var(10)<=1
trigger1 = frontedgedist <= -50
trigger2 = var(10)=2
trigger2 = frontedgedist <= -250
trigger3 = var(10)>=3
Trigger3 = FrontEdgeDist <= -450
trigger4 = frontedgedist < 0
trigger4 = var(16) >= 60 ;Return to screen if off for more than 1 sec
Value = 1103;2

[State 1101, Offscreen Timer]
type = varadd
trigger1 = frontedgedist < 0
var(16) = 1

;---------------------------------------------------------------------------
; Rocket Dive Recover
[Statedef 1102]
type = A
movetype = I
physics = N
velset = 0,0
ctrl = 0
anim = 1102+0*(var(13):=0)+0*(var(47):=0)
sprpriority = 1
movehitpersist=1

[State 0, RemoveExplod]
type = RemoveExplod
trigger1 = time=0
id = 30000
[State 0, RemoveExplod]
type = RemoveExplod
trigger1 = time=0
id = 30001
[State 0, PalFX]
type = PalFX
trigger1 = time=0
time = 0

[State 1201, PlayerPush]
type = PlayerPush
trigger1 = 1
value = 0

[State 0, ScreenBound]
type = ScreenBound
trigger1 = 1
value = 0
movecamera = 0,1
ignorehitpause = 1

[State 1102, PS]
type = PosSet
trigger1 = time = 0
x = ifelse(facing = 1,240,-240)
y = -10-70*(var(10)=2)-140*(var(10)>=3)
persistent=0

[State 1102, VS]
type = velset
trigger1 = time = 0
x = -8

[State 1102, Friction]
type = velmul
trigger1 = time >= 23
trigger1 = frontedgedist > 0
x = 0.9

[State 1102, CS]
type = changestate
trigger1 = animtime = 0
value = 1103

;---------------------------------------------------------------------------
; Rocket Dive Recover
[Statedef 1103]
type = A
movetype = I
physics = N
velset = 0,2
anim = 1103+0*(var(13):=0)+0*(var(47):=0)
ctrl = 0
sprpriority = 1
movehitpersist=1
facep2 = 1

[State 0, ScreenBound]
type = ScreenBound
trigger1 = 1
value = 1
movecamera = 1,0

[State 0, RemoveExplod]
type = RemoveExplod
trigger1 = time=0
id = 30000
[State 0, RemoveExplod]
type = RemoveExplod
trigger1 = time=0
id = 30001
[State 0, PalFX]
type = PalFX
trigger1 = time=0
time = 0

[State 1103, PS]
type = posset
trigger1 = time = 0
y = -gameheight-40-80*(var(10)=2)-160*(var(10)=3)
x = var(11)

[State 1103, T]
type = turn
trigger1 = time <= 1
trigger1 = p2dist x < 0
persistent = 0

[State 1103, Grav]
type = veladd
trigger1 = time
y = 0.5

[State 1103, CS]
type = changestate
trigger1 = vel y > 0
trigger1 = pos y >= -(vel y)
value = 1104

;---------------------------------------------------------------------------
; Jump Land
[Statedef 1104]
type = S
physics = S
ctrl = 0
anim = 47

[State 4010, Explod]
type = Explod
trigger1 = time=0
anim = 21002
ID = 21002
pos = 30,0
postype = p1
bindtime = 1
vel = 8,0
accel = -0.5,0.0
scale = 0.75,0.75
sprpriority = 5
ownpal = 1
supermovetime = 99
[State 4010, Explod]
type = Explod
trigger1 = time=0
anim = 21002
ID = 21002
pos = -30,0
postype = p1
bindtime = 1
vel = -8,0
accel = 0.5,0.0
scale = 0.75,0.75
sprpriority = 5
ownpal = 1
supermovetime = 99

[State 1020, PSND]
type = playsnd
trigger1 = time = 0
value = 40,1

[State 52, 1]
type = VelSet
trigger1 = Time = 0
y = 0

[State 52, 2]
type = PosSet
trigger1 = Time = 0
y = 0

[State 52, 4]
type = VelSet
trigger1 = abs(vel x) < Const(movement.stand.friction.threshold)
x = 0

[State 52, 5]
type = ChangeState
trigger1 = animtime = 0
value = 0
ctrl = 1

;---------------------------------------------------------------------------
; Rocket Dive Armor
[Statedef 1105]
type = U
movetype = H
physics = N
ctrl = 0
sprpriority = 1
movehitpersist=1
hitdefpersist=1

[State 0, PlaySnd]
type = PlaySnd
trigger1 = time=0
value = 1100,12
channel = 6

[State -2, DefenseMulSet]
type = LifeAdd
triggerall = Alive && MoveType = H
trigger1 = (fvar(8) - life)>0
value = floor((0.4 - 1.0) * ifElse((fvar(8)-life) < life, -(fvar(8) - life),0))

[State 1400, Armor Damage Reduction]
type = VarSet
trigger1 = 1
fvar(8) = life
ignorehitpause = 1

[State 0, Explod]
type = Explod
trigger1 = time=0
anim = 21102
ID = 21102
pos = 52,-65
postype = p1 ;p2,front,back,left,right
facing = 1
bindtime = 1
removetime = -2
scale = 2.0,2.0
sprpriority = 5
ownpal = 1
removeongethit = 1
;ignorehitpause =
;trans = 
;persistent =
;supermove = 0
;pausemove = 0

[State 0, ChangeAnim]
type = ChangeAnim
trigger1 = 1
value = anim
elem = animelemno(-1)
ignorehitpause = 1
;persistent = 

[State 0, NotHitBy]
type = NotHitBy
trigger1 = 1
value = SCA,NA,SA,HA,NP,SP,HP,NT,ST,HT
;value2 = S,NA
time = 1
ignorehitpause = 1
;persistent = 

[State 1201, PlayerPush]
type = PlayerPush
trigger1 = 1
value = 0

[State 0, PosFreeze]
type = PosFreeze
trigger1 = 1
value = 1
ignorehitpause = 1

[State 0, RemoveExplod]
type = RemoveExplod
trigger1 = alive=0
id = 30000
[State 0, RemoveExplod]
type = RemoveExplod
trigger1 = alive=0
id = 30001
[State 0, PalFX]
type = PalFX
trigger1 = alive=0
time = 0

[State 1105, CS]
type = changestate
trigger1 = alive=0
value = 5000
ignorehitpause = 1

[State 1105, CS]
type = changestate
trigger1 = time
trigger1 = gethitvar(hitshaketime)=0
value = 1101
ignorehitpause = 1

;---------------------------------------------------------------------------
; Rocket Dive Cancel
[Statedef 1120]
type = S
movetype = I
physics = S
ctrl = 0
anim = 1120+0*(var(13):=0)+0*(var(47):=0)+0*floor(var(8):=(var(8)+1))
sprpriority = 5

[State 0, RemoveExplod]
type = RemoveExplod
trigger1 = time=0
id = 30000
[State 0, RemoveExplod]
type = RemoveExplod
trigger1 = time=0
id = 30001
[State 0, PalFX]
type = PalFX
trigger1 = time=0
time = 0

[State 1120, CS]
type = changestate
trigger1 = time = 0
trigger1 = var(10)>=2
value = cond(var(10)>=3,105,100)
ctrl = 1

[State 1120, CS]
type = changestate
trigger1 = animtime = 0
value = 0
ctrl = 1

;---------------------------------------------------------------------------
; Air Rocket Dive Cancel
[Statedef 1121]
type = A
movetype = I
physics = N
ctrl = 0
anim = 1121+0*(var(13):=0)+0*(var(47):=0)+0*floor(var(8):=(var(8)+1))
sprpriority = 5

[State 0, RemoveExplod]
type = RemoveExplod
trigger1 = time=0
id = 30000
[State 0, RemoveExplod]
type = RemoveExplod
trigger1 = time=0
id = 30001
[State 0, PalFX]
type = PalFX
trigger1 = time=0
time = 0

[State 1121, VA]
type = veladd
trigger1 = animelemtime(3)>0
y = 0.5

[State 1120, CS]
type = changestate
trigger1 = time = 0
trigger1 = var(10)>=2
value = cond(var(10)>=3,115,110)
ctrl = 1

[State 1120, CS]
type = changestate
trigger1 = vel y > 0
trigger1 = pos y >= -(vel y)
value = 1104

;---------------------------------------------------------------------------
; Rocket Dive Wings
[StateDef 21100]
type = A
movetype = I
physics = N
anim = 21100+3100*(root,stateno=4200)
sprpriority = 5;-6*ishelper(21101)

[State 0, VarSet]
type = VarSet
trigger1 = time=0
trigger1 = root,stateno=4200
var(30)=1

[State 1203]
type = BindToRoot
pos = 16+16,-65-(1-2*ishelper(21101))*10
facing = 1
time = 1
trigger1 = 1

[State 1203]
type = Assertspecial
flag = noshadow
trigger1 = 1

[State 1203]
type = Trans
trans = addalpha
alpha = floor(256*sin(pi/32.0*(var(0)%16))),256
trigger1 = time<15

[State 1203]
type = Trans
trans = add
trigger1 = time>14

[State 1203]
type = Null
trigger1 = fvar(0):=(.1*sin(pi/8.*(var(0)%8))*(1-2*ishelper(21101))+1)*1

[State 1203]
type = AngleDraw
value = (60+(var(0)%8)*7.5)
scale = fvar(0),fvar(0)
trigger1 = ishelper(21100)

[State 1203]
type = AngleDraw
value = (180-(60+(var(0)%8)*7.5))
scale = fvar(0),fvar(0)
trigger1 = ishelper(21101)

[State 1203]
type = DestroySelf
;trigger1 = root,time
trigger1 = Root,Movetype = H && root,stateno!=1105 && (root,stateno!=[4200,4201])
trigger2 = Root,Stateno != 1101 && root,stateno!=1105 && (root,stateno!=[4200,4201])

[State 1203, Custom Timer]
type = varadd
trigger1 = root,stateno!=1105
trigger1 = !(root,hitpausetime)
var(0)=1

;---------------------------------------------------------------------------
; Hell Geyser Charge
[Statedef 1200]
type = S
movetype = A
physics = N
velset = 0,0
anim = 1200+0*(var(13):=0)+0*(var(47):=0)+0*(var(18):=0)+0*(var(35):=0)+0*floor(cond(var(57)=2,var(57):=0,1))
poweradd = 0
ctrl = 0
sprpriority = 1
facep2 = 1

[State 1100, NoGuard]
type = attackdist
trigger1 = time>=0
value = 0
ignorehitpause = 1

[State 0, ModifyExplod]
type = Explod
trigger1 = animelemtime(6)>0
persistent=0
ID = 30000
anim = 30000
pos = -40,10
postype = p1
facing=1
bindtime = -1
removetime = -1
scale = 1,1
sprpriority = 4
ontop = 0
ownpal = 1
removeongethit = 1
[State 0, ModifyExplod]
type = Explod
trigger1 = animelemtime(6)>0
persistent=0
ID = 30001
anim = 30001
pos = -40,10
postype = p1
facing=1
bindtime = -1
removetime = -1
scale = 0.5,1
sprpriority = 5
ontop = 0
ownpal = 1
removeongethit = 1

[State 1100, VA]
type = varadd
triggerall = animelemtime(6)>0
triggerall = var(13)<70;90
trigger1 = var(10)<=1
trigger1 = command="holdx"||command="holdc"
trigger2 = var(10)=2
trigger2 = command="holdy"||command="holdb"||command="holdc"
trigger3 = var(10)>=3
trigger3 = command="holdz"||command="holdb"||command="holdc"
var(13)=1

[State 0, ModifyExplod]
type = ModifyExplod
trigger1 = animelemtime(6)>0
ID = 30001
;anim = ifelse(var(13)>=90,30002,30001)
scale = (1.0*var(13)/70.0),1.0

[State -3, PSND]
type = playsnd
triggerall = roundstate=2
trigger1 = var(13)=30
trigger1 = (var(47):=90)||1
trigger2 = var(13)=70;90
trigger2 = (var(47):=150)||1
value = 1000,11
channel = 6

[State -3, PSND]
type = playsnd
trigger1 = var(13)=70;90
value = 1010,10
channel = 7

[State 4010, Explod]
type = Explod
trigger1 = var(13)=30
trigger2 = var(13)=70;90
anim = 21002
ID = 21002
pos = 30,0
postype = p1
bindtime = 1
vel = 8,0
accel = -0.5,0.0
scale = 0.75,0.75
sprpriority = 5
ownpal = 1
supermovetime = 99
[State 4010, Explod]
type = Explod
trigger1 = var(13)=30
trigger2 = var(13)=70;90
anim = 21002
ID = 21002
pos = -30,0
postype = p1
bindtime = 1
vel = -8,0
accel = 0.5,0.0
scale = 0.75,0.75
sprpriority = 5
ownpal = 1
supermovetime = 99

[State 1100, VA]
type = changestate
triggerall = var(8)=0
triggerall = animelemtime(6)>0
triggerall = var(13)<70;90
trigger1 = command="22"
trigger1 = (var(10):=1)||1
trigger2 = command = "FF" || (command = "holdfwd" && command!="holdback" && (command="a"))
trigger2 = (var(10):=2)||1
trigger3 = command = "BB" || (command = "holdback" && command!="holdfwd" && (command="a"))
trigger3 = (var(10):=3)||1
value = 1220

[State 1100, CS]
type = changeanim
triggerall = anim=1200
trigger1 = (var(10)<=1&&command!="holdx"&&command!="holdc")||(var(10)=2&&command!="holdy"&&command!="holdb"&&command!="holdc")||(var(10)>=3&&command!="holdz"&&command!="holdb"&&command!="holdc")
trigger1 = animelemtime(6)>=0
trigger2 = (var(10)<=1&&command="rlsx")||(var(10)=2&&command="rlsy")||(var(10)>=3&&command="rlsz")||(var(10)>=2&&command="rlsb")||(command="rlsc")
trigger2 = animelemtime(6)>0
trigger3 = time>=89
value = 1201

[State 1100, CS]
type = changestate
trigger1 = anim = 1201
trigger1 = (var(17):=0)||1
value = 1201

;---------------------------------------------------------------------------
; Hell Geyser Active
[Statedef 1201]
type = S
movetype = A
physics = S
;velset = 0,0
poweradd = 30+15*(var(47)=150)
ctrl = 0
anim=1201
sprpriority = 1
;movehitpersist=1

[State 0, Width]
type = Width
trigger1 = animelemtime(2)>=0
value = 40,0
ignorehitpause = 1
;persistent = 

[State 0, AttackDist]
type = AttackDist
trigger1 = var(10)>=2
trigger1 = animelemtime(3)<=20
value = 320
ignorehitpause = 
;persistent = 

[State 0, RemoveExplod]
type = RemoveExplod
trigger1 = animelemtime(1)=0
trigger1 = var(13)>=70;90
id = 30001

[State 0, ModifyExplod]
type = Explod
trigger1 = animelemtime(1)=0
trigger1 = var(13)>=70;90
persistent=0
ID = 30001
anim = 30002
pos = -40,10
postype = p1
facing=1
bindtime = -1
removetime = -1
scale = 1.0,1
sprpriority = 5
ontop = 0
ownpal = 1
removeongethit = 1

[State 1000, Effect]
type = helper
trigger1 = animelemtime(3)=0
helpertype = normal
name = "HellGeyser"
ID = 21200
pos = 55+ifelse(var(47)=150,70,ifelse(var(47)=90,92,115))*(var(10)=2)+230*(var(10)>=3),0
postype = p1
stateno = 21200
ownpal = 1
facing = 1
size.xscale=0.75
size.yscale=0.75
[State 1000, Effect]
type = helper
trigger1 = animelemtime(3)=10
trigger1 = var(47)=90||var(47)=150
helpertype = normal
name = "HellGeyser"
ID = 21200
pos = 100+ifelse(var(47)=150,70,93)*(var(10)=2)+140*(var(10)>=3),0
postype = p1
stateno = 21200
ownpal = 1
facing = 1
size.xscale=0.75
size.yscale=0.75
[State 1000, Effect]
type = helper
trigger1 = animelemtime(3)=20
trigger1 = var(47)=150
helpertype = normal
name = "HellGeyser"
ID = 21200
pos = 145+70*(var(10)=2)+50*(var(10)>=3),0
postype = p1
stateno = 21200
ownpal = 1
facing = 1
size.xscale=0.75
size.yscale=0.75

[State 21200, PSND]
type = playsnd
trigger1 = time=0
value = 220,0
channel = 0

[State 0, RemoveExplod]
type = RemoveExplod
trigger1 = animelemtime(12)=0
id = 30000+0*(var(13):=0)+0*(var(47):=0)
[State 0, RemoveExplod]
type = RemoveExplod
trigger1 = animelemtime(12)=0
id = 30001
[State 0, PalFX]
type = PalFX
trigger1 = animelemtime(12)=0
time = 0

[State -2, FLAG RECOVERY FRAMES]
type = statetypeset
trigger1 = animelemtime(12)=0
movetype = I
ignorehitpause = 1
persistent = 0

[State 1000, VS]
type = varset
trigger1 = animelemtime(12)>=0
var(1)=1

[State -2, FLAG RECOVERY FRAMES]
type = statetypeset
trigger1 = var(47)!=90 && var(47)!=150
trigger1 = animelemtime(3)=1
trigger2 = var(47)=90
trigger2 = animelemtime(3)=11
trigger3 = var(47)=150
trigger3 = animelemtime(3)=21
movetype = I
ignorehitpause = 1
persistent = 0

[State 1000, CS]
type = ChangeState
trigger1 = animtime = 0
value = 0
ctrl = 1

;---------------------------------------------------------------------------
; Hell Geyser Cancel
[Statedef 1220]
type = S
movetype = I
physics = S
ctrl = 0
anim = 1220+0*(var(13):=0)+0*(var(47):=0)+0*floor(var(8):=(var(8)+1))
sprpriority = 5

[State 0, RemoveExplod]
type = RemoveExplod
trigger1 = time=0
id = 30000
[State 0, RemoveExplod]
type = RemoveExplod
trigger1 = time=0
id = 30001
[State 0, PalFX]
type = PalFX
trigger1 = time=0
time = 0

[State 1120, CS]
type = changestate
trigger1 = time = 0
trigger1 = var(10)>=2
value = cond(var(10)>=3,105,100)
ctrl = 1

[State 1120, CS]
type = changestate
trigger1 = animtime = 0
value = 0
ctrl = 1

;---------------------------------------------------------------------------
; Hell Geyser
[Statedef 21200]
type = S
movetype = A
physics = N
velset = 0,0
anim = 1998
poweradd = 0
ctrl = 0
sprpriority = 5

[State 0, PlaySnd]
type = PlaySnd
trigger1 = time=0
value = 1200,11
channel = 7

[State 21200, VS]
type = varset
trigger1 = time=0
var(10)=root,var(10)

[State 21200, VS]
type = varset
trigger1 = time=0
var(11)=ifelse((root,var(47))=150,3,ifelse((root,var(47))=90,2,1))

[State 21200, CA]
type = changeanim
trigger1 = time = 0
value = 21200+1*(var(10)=2)+2*(var(10)>=3)

[State 1201, EnvShake]
type = EnvShake
trigger1 = animelemtime(1)=0
time = 20
freq = 120
ampl = -4
ignorehitpause=1

[State 21000, ASS]
type = assertspecial
trigger1=1
flag=noshadow
ignorehitpause=1

[State 21000, Trans]
type = trans
trigger1=1
trans = addalpha
alpha = 256,256
ignorehitpause=1

[State 1010, NHB]
type = nothitby
trigger1 = 1
value = ,AA,AT
ignorehitpause = 1

[State 1010, HitOverride]
Type = HitOverride
Trigger1 = 1
Attr = SCA,AA,AP;,AT
slot = 0
time = -1
Stateno = 21205
IgnoreHitPause = 1

[State 21200, VS]
type = varset
trigger1 = time = 0
var(35) = root,var(35)
[State Movehitoner]
type = VarSet
trigger1 = numenemy
var(31) = ifelse(movehit=1&&(enemynear,movereversed!=[1,2]),var(31)+1,0)
ignorehitpause = 1
[State Give 'em a lil' 40, taken from The_None]
type = parentVarSet
trigger1 = var(31) = [1,2]
trigger1 = numtarget
trigger1 = (target,statetype = A) || (target,statetype = L)
var(34) = root,var(34) | floor(exp(4*ln(2)) + 0.5) ;Flag the move if the move has hit in a juggle way.
ignorehitpause = 1
persistent = 0

[State 1010, HitDef]
type = Hitdef
triggerall = !((root,var(34))&floor(exp(4*ln(2)) + 0.5)) || var(35)
trigger1 = !movecontact && !movereversed
attr = S,SP
animtype = Hard
damage = ceil((80.0-10.0*(var(11)=2)-16.0*(var(11)=3))*(root,fvar(11)/cond(root,var(57)=2,(root,fvar(30)),1))),16-3*(var(11)=2)-5*(var(11)=3)
priority = 4,Hit
hitflag = MAF
guardflag = MA
pausetime = 0,4
sparkno = s8010+(random%2)
guard.sparkno = s8030
sparkxy = -10,ceil(p2dist y)-50
hitsound = s1,3
guardsound = s2,0
ground.type = High
ground.slidetime = 19
ground.hittime = 19
air.hittime = 19
guard.slidetime = 15
guard.hittime = 15
ground.velocity = -7.0*ifelse(var(10)>=3,-1,1)*ifelse(var(10)=2,0.67,1),-3.0*ifelse(var(10)=2,2,1)
guard.velocity = -7.0*ifelse(var(10)>=3,-1,1)*ifelse(var(10)=2,0.67,1)
air.velocity = -7.0*ifelse(var(10)>=3,-1,1)*ifelse(var(10)=2,0.67,1),-3.0*ifelse(var(10)=2,2,1)
airguard.velocity = -7.0*ifelse(var(10)>=3,-1,1)*ifelse(var(10)=2,0.67,1),-3.0*ifelse(var(10)=2,2,1)
yaccel=0.5
p1sprpriority=5
fall = 1
air.fall = 1
fall.recover = 1
fall.recovertime = 120
getpower = 60-15*(var(11)=2)-30*(var(11)=3),60-15*(var(11)=2)-30*(var(11)=3)
givepower = 30-8*(var(11)=2)-15*(var(11)=3),30-8*(var(11)=2)-15*(var(11)=3)
ground.cornerpush.veloff = 0
guard.cornerpush.veloff = 0
air.cornerpush.veloff = 0
id = 1200

[State 220, First Combo Hit]
type = parentvarset
triggerall = numtarget(1200)
trigger1 = target(1200),gethitvar(hitcount)=1
trigger1 = root,var(57)=0
var(57) = 2;Change index
ignorehitpause = 1
persistent = 0

[State 200, Damage Dampen]
type = parentvarset
trigger1 = movehit
fvar(10) = (root,fvar(10))*cond(var(11)<2,0.85,cond(var(11)=2,0.89,0.9))*cond(root,fvar(10)>=1.0,(root,fvar(30)),1.0);0.8
ignorehitpause = 1
persistent = 0

[State 200, Damage Dampen]
type = parentvarset
trigger1 = movecontact
var(35) = 1
ignorehitpause = 1
persistent = 0

[State -2, FLAG RECOVERY FRAMES]
type = statetypeset
trigger1 = animelemtime(9)=0
trigger2 = movecontact||movereversed
movetype = I
ignorehitpause = 1
persistent = 0

[State 21100, CS]
type = changeanim
trigger1 = anim!=1998
trigger1 = animtime = 0
value = 1998

[State 21100, CS]
type = changestate
trigger1 = anim=1998
trigger2 = movecontact||movereversed
value = 21205

;-----------------------
; Hell Geyser Destroy
[Statedef 21205]
type = S
movetype = I
physics = N
sprpriority = 5
;velset = 0,0
movehitpersist = 1

[State 21100, CS]
type = changeanim
trigger1 = anim!=1998
trigger1 = animtime = 0
value = 1998

[State -2, P2 Safe Fall]
type = targetstate
triggerall = numtarget=1 ;Just to prevent Simul mode shenanigans
triggerall = target,pos y>=-20 && target,vel y>0
triggerall = target,alive && target,hitfall && target,gethitvar(fall.recover)
triggerall = target,stateno=5030 || target,stateno=5035 || target,stateno=5050 || target,stateno=5071
trigger1 = target,AILevel <= 0
trigger1 = target,command="recovery"
trigger2 = target,AILevel > 0
trigger2 = random%100 <= 10*ceil((target,AILevel)*(target,AILevel)/64.0)
value = 5205
ignorehitpause = 1

[State 1015, T]
type = trans
trigger1 = 1
trans = addalpha
alpha = 256,256
ignorehitpause = 1

[State 1015, ASS]
type = assertspecial
trigger1 = 1
flag = noshadow
ignorehitpause = 1

[State 1015, NHB]
type = nothitby
trigger1 = 1
value = SCA,AA,AP,AT
ignorehitpause = 1

[State 1015, Destroyself]
type = changestate
trigger1 = anim=1998
trigger1 = time>=5
value = 999

;---------------------------------------------------------------------------
; Flare Up Charge
[Statedef 1300]
type = S
movetype = A
physics = N
velset = 0,0
anim = 1300+0*(var(13):=0)+0*(var(47):=0)+0*(var(18):=0)+0*(var(35):=0)+0*floor(cond(var(57)=3,var(57):=0,1))
poweradd = 0
ctrl = 0
sprpriority = 1
facep2 = 1

[State 1300, GCC Version?]
type = varset
trigger1 = time = 0
var(24) = cond(prevstateno=1900,1,0)

[State 1100, NoGuard]
type = attackdist
trigger1 = time>=0
value = 0
ignorehitpause = 1

[State 0, NotHitBy]
type = NotHitBy
trigger1 = time=0 && prevstateno!=1900
value = SCA,AA,AP,AT
time = 28-7*(var(10)=2)-14*(var(10)>=3)
ignorehitpause = 1

[State 0, NotHitBy]
type = NotHitBy
trigger1 = time=0 && prevstateno=1900
value = SCA,AA,AP,AT
time = 30
ignorehitpause = 1

[State 0, ModifyExplod]
type = Explod
trigger1 = animelemtime(4)>0
persistent=0
ID = 30000
anim = 30000
pos = -40,10
postype = p1
facing=1
bindtime = -1
removetime = -1
scale = 1,1
sprpriority = 4
ontop = 0
ownpal = 1
removeongethit = 1
[State 0, ModifyExplod]
type = Explod
trigger1 = animelemtime(4)>0
persistent=0
ID = 30001
anim = 30001
pos = -40,10
postype = p1
facing=1
bindtime = -1
removetime = -1
scale = 0.5,1
sprpriority = 5
ontop = 0
ownpal = 1
removeongethit = 1

[State 1100, VA]
type = varadd
triggerall = animelemtime(4)>0
triggerall = var(13)<70;90
triggerall = prevstateno!=1900
trigger1 = var(10)<=1
trigger1 = command="holdx"||command="holdc"
trigger2 = var(10)=2
trigger2 = command="holdy"||command="holdb"||command="holdc"
trigger3 = var(10)>=3
trigger3 = command="holdz"||command="holdb"||command="holdc"
var(13)=1

[State 0, ModifyExplod]
type = ModifyExplod
trigger1 = animelemtime(4)>0
ID = 30001
;anim = ifelse(var(13)>=90,30002,30001)
scale = (1.0*var(13)/70.0),1.0

[State -3, PSND]
type = playsnd
triggerall = roundstate=2
trigger1 = var(13)=30
trigger1 = (var(47):=90)||1
trigger2 = var(13)=70;90
trigger2 = (var(47):=150)||1
value = 1000,11
channel = 6

[State -3, PSND]
type = playsnd
trigger1 = var(13)=70
value = 1010,10
channel = 7

[State 4010, Explod]
type = Explod
trigger1 = var(13)=30
trigger2 = var(13)=70;90
anim = 21002
ID = 21002
pos = 30,0
postype = p1
bindtime = 1
vel = 8,0
accel = -0.5,0.0
scale = 0.75,0.75
sprpriority = 5
ownpal = 1
supermovetime = 99
[State 4010, Explod]
type = Explod
trigger1 = var(13)=30
trigger2 = var(13)=70;90
anim = 21002
ID = 21002
pos = -30,0
postype = p1
bindtime = 1
vel = -8,0
accel = 0.5,0.0
scale = 0.75,0.75
sprpriority = 5
ownpal = 1
supermovetime = 99

[State 1100, VA]
type = changestate
triggerall = var(8)=0
triggerall = animelemtime(4)>0
triggerall = var(13)<70;90
trigger1 = command="22"
trigger1 = (var(10):=1)||1
trigger2 = command = "FF" || (command = "holdfwd" && command!="holdback" && (command="a"))
trigger2 = (var(10):=2)||1
trigger3 = command = "BB" || (command = "holdback" && command!="holdfwd" && (command="a"))
trigger3 = (var(10):=3)||1
value = 1320

[State 1100, CS]
type = changeanim
triggerall = anim=1300
trigger1 = (var(10)<=1&&command!="holdx"&&command!="holdc")||(var(10)=2&&command!="holdy"&&command!="holdb"&&command!="holdc")||(var(10)>=3&&command!="holdz"&&command!="holdb"&&command!="holdc")
trigger1 = animelemtime(4)>=0
trigger2 = (var(10)<=1&&command="rlsx")||(var(10)=2&&command="rlsy")||(var(10)>=3&&command="rlsz")||(var(10)>=2&&command="rlsb")||(command="rlsc")
trigger2 = animelemtime(4)>0
trigger3 = var(13)>=70
trigger4 = animelemtime(4)>=0
trigger4 = prevstateno = 1900
value = 1301

[State 1100, CS]
type = changestate
trigger1 = anim = 1301
trigger1 = (var(17):=0)||1
value = 1301

;---------------------------------------------------------------------------
; Flare Up Active
[Statedef 1301]
type = S
movetype = A
physics = S
;velset = 0,0
poweradd = (30+15*(var(47)=150))*(var(24)=0)
ctrl = 0
anim=1301+1*(var(10)=2)+2*(var(10)>=3)
sprpriority = 1

[State 0, RemoveExplod]
type = RemoveExplod
trigger1 = animelemtime(1)=0
trigger1 = var(13)>=70;90
id = 30001

[State 0, ModifyExplod]
type = Explod
trigger1 = animelemtime(1)=0
trigger1 = var(13)>=70;90
persistent=0
ID = 30001
anim = 30002
pos = -40,10
postype = p1
facing=1
bindtime = -1
removetime = -1
scale = 1.0,1
sprpriority = 5
ontop = 0
ownpal = 1
removeongethit = 1

[State 1000, Effect]
type = helper
trigger1 = animelemtime(3)=0
helpertype = normal
name = "FlareProj"
ID = 21300
pos = 0,0
postype = p1
stateno = 21300
ownpal = 1
facing = 1
[State 1000, Effect]
type = helper
trigger1 = animelemtime(3)=0
helpertype = normal
name = "FlareProj"
ID = 21301
pos = 0,0
postype = p1
stateno = 21300
ownpal = 1
facing = 1

[State 1000, Effect]
type = helper
trigger1 = animelemtime(3)=0||animelemtime(3)=4||animelemtime(3)=8||animelemtime(3)=12
helpertype = normal
name = "FlareProj"
ID = 21320
pos = 0,0
postype = p1
stateno = 21320
ownpal = 1
facing = 1

[State 1301, PSND]
type = PlaySnd
trigger1 = animelemtime(3) = 0
value = 1300,0
channel = 0

[State 0, RemoveExplod]
type = RemoveExplod
trigger1 = animelemtime(14)=0
id = 30000+0*(var(13):=0)+0*(var(47):=0)
[State 0, RemoveExplod]
type = RemoveExplod
trigger1 = animelemtime(14)=0
id = 30001
[State 0, PalFX]
type = PalFX
trigger1 = animelemtime(14)=0
time = 0

[State -2, FLAG RECOVERY FRAMES]
type = statetypeset
trigger1 = animelemtime(3)=14
movetype = I
ignorehitpause = 1
persistent = 0

[State 1000, VS]
type = varset
trigger1 = animelemtime(3)>=14
var(1)=1

[State 1000, CS]
type = ChangeState
trigger1 = animtime = 0
value = 0
ctrl = 1

;---------------------------------------------------------------------------
; Flare Up Bullet
[Statedef 21300]
type = A
movetype = A
physics = N
velset = 0,0
anim = 1998
poweradd = 0
ctrl = 0
sprpriority = 5

[State 21300, VS]
type = varset
trigger1 = time = 0
var(24) = root,var(24)

[State 0, PlaySnd]
type = PlaySnd
trigger1 = time=0 
value = 1000,10
channel = 6

[State 21200, VS]
type = varset
trigger1 = time=0
var(10)=root,var(10)

[State 21200, VS]
type = varset
trigger1 = time=0
var(11)=ifelse((root,var(47))=150,3,ifelse((root,var(47))=90,2,1))

[State 21300, CVS]
type = null
triggerall = time=0
trigger1 = (var(10)<=1) && (var(11)<=1)
trigger1 = (var(13):=20)||1
trigger2 = (var(10)=2) && (var(11)<=1)
trigger2 = (var(13):=22)||1
trigger3 = (var(10)>=3) && (var(11)<=1)
trigger3 = (var(13):=24)||1
; Level 2 Charge
trigger4 = (var(10)<=1) && (var(11)=2)
trigger4 = (var(13):=30)||1
trigger5 = (var(10)=2) && (var(11)=2)
trigger5 = (var(13):=33)||1
trigger6 = (var(10)>=3) && (var(11)=2)
trigger6 = (var(13):=36)||1
; Level 3 Charge
trigger7 = (var(10)<=1) && (var(11)>=3)
trigger7 = (var(13):=40)||1
trigger8 = (var(10)=2) && (var(11)>=3)
trigger8 = (var(13):=44)||1
trigger9 = (var(10)>=3) && (var(11)>=3)
trigger9 = (var(13):=48)||1

[State 21300, CS]
type = changestate
trigger1 = 1
value = 21301

;---------------------------------------------------------------------------
; Flare Up Bullet
[Statedef 21301]
type = A
movetype = A
physics = N
velset = 0,-8.0;-3.0;+0.5*(var(10)=2)+1.0*(var(10)>=3)
anim = 21300
poweradd = 0
ctrl = 0
sprpriority = 5
movehitpersist=1

[State 21301, ASS]
type = assertspecial
trigger1 = 1
flag = noshadow
ignorehitpause = 1

[State 21000, Trans]
type = trans
trigger1=1
trans = addalpha
alpha = 256,256
ignorehitpause=1

[State 1010, NHB]
type = nothitby
trigger1 = 1
value = ,AA,AT
ignorehitpause = 1

[State 1010, HitOverride]
Type = HitOverride
Trigger1 = 1
Attr = SCA,AA,AP;,AT
slot = 0
time = -1
Stateno = 21301
IgnoreHitPause = 1

[State VelSet]
type = VelSet
trigger1 = var(0)
x = 2*(8.5+4.25*(var(10)=2)+8.5*(var(10)>=3))*cos(pi*(((2*var(0)+25*ishelper(21301))%50)/25.0))

[State Sparkle]
Type = AngleSet
Trigger1 = time
Value = random%360

[State DrawMeAngled]
type = AngleDraw
trigger1 = 1
scale = .75,.75

[State MustGoFaster]
type = VelMul
trigger1 = var(0)<60
y = 1.04

[State 21301, Explod]
type = Explod
trigger1 = 1;numexplod(21301)=0
ID = 21301
anim = 21301
pos = 0,0
postype = p1
facing=1
bindtime = -1
removetime = -2
scale = 0.75,0.75
sprpriority = 5
ownpal = 0
removeongethit = 1

[State 1000, Effect]
type = helper
trigger1 = var(0)%5=0
helpertype = normal
name = "FlareProj"
ID = 21310
pos = 0,0
postype = p1
stateno = 21310
ownpal = 0
facing = 1

[State MOVEHITRESET]
type = MoveHitReset
trigger1 = movecontact>=10

[State 21200, VS]
type = varset
trigger1 = time = 0
var(35) = root,var(35)
[State Movehitoner]
type = VarSet
trigger1 = numenemy
var(31) = ifelse(movehit=1&&(enemynear,movereversed!=[1,2]),var(31)+1,0)
ignorehitpause = 1
[State Give 'em a lil' 40, taken from The_None]
type = parentVarSet
trigger1 = var(31) = [1,2]
trigger1 = numtarget
trigger1 = (target,statetype = A) || (target,statetype = L)
var(34) = root,var(34) | floor(exp(5*ln(2)) + 0.5) ;Flag the move if the move has hit in a juggle way.
ignorehitpause = 1
persistent = 0

[State 1010, HitDef]
type = Hitdef
triggerall = !((root,var(34))&floor(exp(5*ln(2)) + 0.5)) || (root,var(35)) || (prevstateno!=21300)
trigger1 = !movecontact && !movereversed
trigger1 = var(0)
attr = A,SP
animtype = Hard
damage = ceil(1.0*var(13)*(root,fvar(11)/cond(root,var(57)=3,(root,fvar(30)),1))),ceil(0.2*var(13))
priority = 4,Hit
hitflag = MAF
guardflag = MA
pausetime = 0,4
sparkno = s8010+(random%2)
guard.sparkno = s8030
sparkxy = -10,ceil(p2dist y)-50
hitsound = s1,9
guardsound = s2,0
ground.type = High
ground.slidetime = 8
ground.hittime = 8
air.hittime = 8
guard.slidetime = 8
guard.hittime = 8
ground.velocity = -2.0*ifelse(root,p2dist x<0,-1,1),-5.0
guard.velocity = -2.0*ifelse(root,p2dist x<0,-1,1)
air.velocity = -2.0*ifelse(root,p2dist x<0,-1,1),-5.0
airguard.velocity = -2.0*ifelse(root,p2dist x<0,-1,1),-5.0
yaccel=0.5
p1sprpriority=5
fall = 1
air.fall = 1
fall.recover = 1
fall.recovertime = 120
getpower = 20*(var(24)=0),20*(var(24)=0)
givepower = 10,10
ground.cornerpush.veloff = 0
guard.cornerpush.veloff = 0
air.cornerpush.veloff = 0
id = 1300

[State 220, First Combo Hit]
type = parentvarset
triggerall = numtarget(1300)
trigger1 = target(1300),gethitvar(hitcount)=1
trigger1 = root,var(57)=0
var(57) = 3;Change index
ignorehitpause = 1
persistent = 0

[State -2, FLAG RECOVERY FRAMES]
type = statetypeset
trigger1 = movecontact||movereversed
movetype = I
ignorehitpause = 1
persistent = 0

[State 200, Damage Dampen]
type = parentvarset
trigger1 = movehit=1
fvar(10) = (root,fvar(10))*0.9*cond(root,fvar(10)>=1.0,(root,fvar(30)),1.0)
;ignorehitpause = 1
;persistent = 0

[State 200, Damage Dampen]
type = parentvarset
trigger1 = movecontact
var(35) = 1
ignorehitpause = 1
persistent = 0

[State 21300, Custom Timer]
type = varadd
trigger1 = 1
var(0)=1

[State KillExplod]
type = RemoveExplod
trigger1 = FrontEdgeDist < -160
trigger2 = var(0)>150;!(Pos Y = [-330,90])
trigger3 = BackEdgeDist < -160
ID = 10001
ignorehitpause = 1

[State DONE]
type = Changestate
trigger1 = FrontEdgeDist < -160
trigger2 = var(0)>150;!(Pos Y = [-330,90])
trigger3 = BackEdgeDist < -160
trigger4 = screenpos y < -50
value = 999

;---------------------------------------------------------------------------
; Flare Up Bullet FX
[Statedef 21310]
type = A
movetype = I
physics = N
velset = 0,0
anim = 21302
poweradd = 0
ctrl = 0
sprpriority = 5

[State RandomAngle]
type = AngleSet
trigger1 = !time
value = random%360
ignorehitpause = 1

[State Turn]
type = AngleAdd
trigger1 = time
value = 1
ignorehitpause = 1

[State 21310, Scale]
type = AngleDraw
trigger1 = 1
scale = .5,.5
ignorehitpause =1

[State 21310, Trans]
type=trans
trigger1=1
trans=add
ignorehitpause=1

[State 21310, NHB]
Type = NotHitBy
Trigger1 = 1
Value = SCA,AA,AP,AT
Time = 1

[State NoShadowForYou]
type = AssertSpecial
trigger1 = 1
flag = noshadow
ignorehitpause = 1

[State DONE]
type = DestroySelf
trigger1 = !animtime
ignorehitpause = 1

;---------------------------------------------------------------------------
; Flare Up Bullet
[Statedef 21320]
type = A
movetype = A
physics = N
velset = 0,0
anim = 1998;21310
poweradd = 0
ctrl = 0
sprpriority = 5

[State 1010, NHB]
type = nothitby
trigger1 = 1
value = SCA,AA,AP,AT
ignorehitpause = 1

[State 1010, HitOverride]
Type = HitOverride
Trigger1 = 1
Attr = SCA,AA,AP
slot = 0
time = -1
Stateno = 21321
IgnoreHitPause = 1

[State 21300, VS]
type = varset
trigger1 = time = 0
var(24) = root,var(24)

[State 21200, VS]
type = varset
trigger1 = time=0
var(10)=root,var(10)

[State 21300, CA]
type = changeanim
trigger1 = time = 0
value = 21310+1*(var(10)=2)+2*(var(10)>=3)

[State 21200, VS]
type = varset
trigger1 = time=0
var(11)=ifelse((root,var(47))=150,3,ifelse((root,var(47))=90,2,1))

[State 21300, CVS]
type = null
triggerall = time=0
trigger1 = (var(10)<=1) && (var(11)<=1)
trigger1 = (var(13):=20)||1
trigger2 = (var(10)=2) && (var(11)<=1)
trigger2 = (var(13):=22)||1
trigger3 = (var(10)>=3) && (var(11)<=1)
trigger3 = (var(13):=24)||1
; Level 2 Charge
trigger4 = (var(10)<=1) && (var(11)=2)
trigger4 = (var(13):=30)||1
trigger5 = (var(10)=2) && (var(11)=2)
trigger5 = (var(13):=33)||1
trigger6 = (var(10)>=3) && (var(11)=2)
trigger6 = (var(13):=36)||1
; Level 3 Charge
trigger7 = (var(10)<=1) && (var(11)>=3)
trigger7 = (var(13):=40)||1
trigger8 = (var(10)=2) && (var(11)>=3)
trigger8 = (var(13):=44)||1
trigger9 = (var(10)>=3) && (var(11)>=3)
trigger9 = (var(13):=48)||1

[State 21300, CS]
type = changestate
trigger1 = 1
value = 21321

;---------------------------------------------------------------------------
; Flare Up Bullet
[Statedef 21321]
type = A
movetype = A
physics = N
velset = 0,0
poweradd = 0
ctrl = 0
sprpriority = 5
movehitpersist=1

[State 21301, ASS]
type = assertspecial
trigger1 = 1
flag = noshadow
ignorehitpause = 1

[State 21000, Trans]
type = trans
trigger1=1
trans = addalpha
alpha = 256,256
ignorehitpause=1

[State 1010, NHB]
type = nothitby
trigger1 = 1
value = ,AA,AT
ignorehitpause = 1

[State 1010, HitOverride]
Type = HitOverride
Trigger1 = 1
Attr = SCA,AA,AP;,AT
slot = 0
time = -1
Stateno = 21321
IgnoreHitPause = 1

[State 21200, VS]
type = varset
trigger1 = time = 0
var(35) = root,var(35)
[State Movehitoner]
type = VarSet
trigger1 = numenemy
var(31) = ifelse(movehit=1&&(enemynear,movereversed!=[1,2]),var(31)+1,0)
ignorehitpause = 1
[State Give 'em a lil' 40, taken from The_None]
type = parentVarSet
trigger1 = var(31) = [1,2]
trigger1 = numtarget
trigger1 = (target,statetype = A) || (target,statetype = L)
var(34) = root,var(34) | floor(exp(5*ln(2)) + 0.5) ;Flag the move if the move has hit in a juggle way.
ignorehitpause = 1
persistent = 0

[State 1010, HitDef]
type = Hitdef
triggerall = !((root,var(34))&floor(exp(5*ln(2)) + 0.5)) || (root,var(35)) || (prevstateno!=21300)
trigger1 = !movecontact && !movereversed
trigger1 = var(0)
attr = A,SP
animtype = Hard
damage = ceil(1.0*var(13)*(root,fvar(11)/cond(root,var(57)=3,(root,fvar(30)),1))),ceil(0.2*var(13))
priority = 4,Hit
hitflag = MAF
guardflag = MA
pausetime = 0,4
sparkno = s8010+(random%2)
guard.sparkno = s8030
sparkxy = -10,ceil(p2dist y)-50
hitsound = s1,9
guardsound = s2,0
ground.type = High
ground.slidetime = 8
ground.hittime = 8
air.hittime = 8
guard.slidetime = 8
guard.hittime = 8
ground.velocity = -5.0*ifelse(root,p2dist x<0,-1,1),-5.0
guard.velocity = -5.0*ifelse(root,p2dist x<0,-1,1)
air.velocity = -5.0*ifelse(root,p2dist x<0,-1,1),-5.0
airguard.velocity = -5.0*ifelse(root,p2dist x<0,-1,1),-5.0
yaccel=0.5
p1sprpriority=5
fall = 1
air.fall = 1
fall.recover = 1
fall.recovertime = 120
getpower = 20*(var(24)=0),20*(var(24)=0)
givepower = 10,10
ground.cornerpush.veloff = 0
guard.cornerpush.veloff = 0
air.cornerpush.veloff = 0
id = 1300

[State 220, First Combo Hit]
type = parentvarset
triggerall = numtarget(1300)
trigger1 = target(1300),gethitvar(hitcount)=1
trigger1 = root,var(57)=0
var(57) = 3;Change index
ignorehitpause = 1
persistent = 0

[State -2, FLAG RECOVERY FRAMES]
type = statetypeset
trigger1 = movecontact||movereversed
movetype = I
persistent = 0
ignorehitpause = 1

[State 200, Damage Dampen]
type = parentvarset
trigger1 = movehit=1
fvar(10) = (root,fvar(10))*0.95*cond(root,fvar(10)>=1.0,(root,fvar(30)),1.0)
;ignorehitpause = 1
;persistent = 0

[State 200, Damage Dampen]
type = parentvarset
trigger1 = movecontact
var(35) = 1
ignorehitpause = 1
persistent = 0

[State 21300, Custom Timer]
type = varadd
trigger1 = 1
var(0)=1

[State DONE]
type = Changestate
trigger1 = animelemtime(1)>=4
value = 999


;---------------------------------------------------------------------------
; Flare Up Cancel
[Statedef 1320]
type = S
movetype = I
physics = S
ctrl = 0
anim = 1320+0*(var(13):=0)+0*(var(47):=0)+0*floor(var(8):=(var(8)+1))
sprpriority = 5

[State 1320, NotHitBy]
type = NotHitBy
trigger1 = time=0
value =
time = 0

[State 0, RemoveExplod]
type = RemoveExplod
trigger1 = time=0
id = 30000
[State 0, RemoveExplod]
type = RemoveExplod
trigger1 = time=0
id = 30001
[State 0, PalFX]
type = PalFX
trigger1 = time=0
time = 0

[State 1120, CS]
type = changestate
trigger1 = time = 0
trigger1 = var(10)>=2
value = cond(var(10)>=3,105,100)
ctrl = 1

[State 1120, CS]
type = changestate
trigger1 = animtime = 0
value = 0
ctrl = 1

;---------------------------------------------------------------------------
; Radiant Blade Charge
[Statedef 1400]
type = S
movetype = A
physics = S
velset = 0,0
anim = 1400+10*(var(10)=2)+20*(var(10)>=3)+0*(var(13):=0)+0*(var(47):=0)+0*(var(18):=0)+0*(var(16):=0)
poweradd = 0
ctrl = 0
sprpriority = 1
facep2 = 1

[State 1100, NoGuard]
type = attackdist
trigger1 = time>=0
value = 0
ignorehitpause = 1

[State 1100, VS]
type = varset
trigger1 = time = 0
var(11) = floor(pos x)

[State -3, PSND]
type = playsnd
trigger1 = animelemtime(2)=1
value = 1100,10
channel = 4

[State 0, ModifyExplod]
type = Explod
trigger1 = animelemtime(2)>0
persistent=0
ID = 30000
anim = 30000
pos = -40,10
postype = p1
facing=1
bindtime = -1
removetime = -1
scale = 1,1
sprpriority = 4
ontop = 0
ownpal = 1
removeongethit = 1
[State 0, ModifyExplod]
type = Explod
trigger1 = animelemtime(2)>0
persistent=0
ID = 30001
anim = 30001
pos = -40,10
postype = p1
facing=1
bindtime = -1
removetime = -1
scale = 0.5,1
sprpriority = 5
ontop = 0
ownpal = 1
removeongethit = 1

[State 1100, VA]
type = varadd
triggerall = animelemtime(2)>0
triggerall = var(13)<70;90
trigger1 = var(10)<=1
trigger1 = command="holdx"||command="holdc"
trigger2 = var(10)=2
trigger2 = command="holdy"||command="holdb"||command="holdc"
trigger3 = var(10)>=3
trigger3 = command="holdz"||command="holdb"||command="holdc"
var(13)=1

[State 0, ModifyExplod]
type = ModifyExplod
trigger1 = animelemtime(2)>0
ID = 30001
;anim = ifelse(var(13)>=90,30002,30001)
scale = (1.0*var(13)/70.0),1.0

[State -3, PSND]
type = playsnd
triggerall = roundstate=2
trigger1 = var(13)=30
trigger1 = (var(47):=90)||1
trigger2 = var(13)=70
trigger2 = (var(47):=150)||1
value = 1000,11
channel = 6

[State -3, PSND]
type = playsnd
trigger1 = var(13)=70;90
value = 1010,10
channel = 7

[State 4010, Explod]
type = Explod
trigger1 = var(13)=30
trigger2 = var(13)=70;90
anim = 21002
ID = 21002
pos = 30,0
postype = p1
bindtime = 1
vel = 8,0
accel = -0.5,0.0
scale = 0.75,0.75
sprpriority = 5
ownpal = 1
supermovetime = 99
[State 4010, Explod]
type = Explod
trigger1 = var(13)=30
trigger2 = var(13)=70;90
anim = 21002
ID = 21002
pos = -30,0
postype = p1
bindtime = 1
vel = -8,0
accel = 0.5,0.0
scale = 0.75,0.75
sprpriority = 5
ownpal = 1
supermovetime = 99

[State 1100, VA]
type = changestate
triggerall = var(8)=0
triggerall = animelemtime(2)>0
triggerall = var(13)<70;90
trigger1 = command="22"
trigger1 = (var(10):=1)||1
trigger2 = command = "FF" || (command = "holdfwd" && command!="holdback" && (command="a"))
trigger2 = (var(10):=2)||1
trigger3 = command = "BB" || (command = "holdback" && command!="holdfwd" && (command="a"))
trigger3 = (var(10):=3)||1
value = cond(statetype=A,1121,1120)

[State 1100, CS]
type = changeanim
trigger1 = (var(10)<=1&&command!="holdx"&&command!="holdc")||(var(10)=2&&command!="holdy"&&command!="holdb"&&command!="holdc")||(var(10)>=3&&command!="holdz"&&command!="holdb"&&command!="holdc")
trigger1 = animelemtime(2)>=0
trigger2 = (var(10)<=1&&command="rlsx")||(var(10)=2&&command="rlsy")||(var(10)>=3&&command="rlsz")||(var(10)>=2&&command="rlsb")||(command="rlsc")
trigger2 = animelemtime(2)>0
trigger3 = animelemtime(2)>=70;90
value = 100;1401

[State 1100, PA]
type = poweradd
trigger1 = anim=100;1401
value = 30+15*(var(13)=70)
persistent = 0

[State 1100, CS]
type = changestate
trigger1 = anim = 100;1401
trigger1 = (var(17):=0)||1
value = 1401

;---------------------------------------------------------------------------
; Radiant Blade Active
[Statedef 1401]
type = S
movetype = A
physics = S
;velset = 0,0
anim = 100
ctrl = 0
poweradd = (30+15*(var(47)=150))
sprpriority = 1
movehitpersist=1
juggle = 0

[State Give 'em a lil' 40, taken from The_None]
type = VarSet
trigger1 = var(31) = [1,2]
trigger1 = numtarget
trigger1 = (target,statetype = A) || (target,statetype = L)
var(34) = var(34) | floor(exp(6*ln(2)) + 0.5) ;Flag the move if the move has hit in a juggle way.
ignorehitpause = 1
persistent = 0

[State Glow]
type = Explod
triggerall = !numexplod(21400)
trigger1 = anim=100
trigger1 = animelemtime(2)>=2
anim = 21401
ID = 21400
bindtime = -1
ownpal = 1
removetime = -1
removeongethit = 1
sprpriority = 5

[State -2, REX]
type = RemoveExplod
triggerall = numexplod(21400)
trigger1 = anim!=100
id = 21400
ignorehitpause = 1

[State 1101, VS]
type = null
triggerall = time = 0
triggerall = prevstateno = 1400
trigger1 = var(10)<=1
trigger1 = (var(18):=80)||1
trigger2 = var(10)=2
trigger2 = (var(18):=90)||1
trigger3 = var(10)>=3
trigger3 = (var(18):=100)||1

[State 0, RemoveExplod]
type = RemoveExplod
trigger1 = time=0
trigger1 = var(13)>=70;90
id = 30001

[State 0, ModifyExplod]
type = Explod
trigger1 = time=0
trigger1 = var(13)>=70;90
persistent=0
ID = 30001
anim = 30002
pos = -40,10
postype = p1
facing=1
bindtime = -1
removetime = -1
scale = 1.0,1
sprpriority = 5
ontop = 0
ownpal = 1
removeongethit = 1

[State 0, RemoveExplod]
type = RemoveExplod
trigger1 = anim=1401
trigger1 = animelemtime(4)=0
id = 30000+0*(var(13):=0)+0*(var(47):=0)
[State 0, RemoveExplod]
type = RemoveExplod
trigger1 = anim=1401
trigger1 = animelemtime(4)=0
id = 30001
[State 0, PalFX]
type = PalFX
trigger1 = anim=1401
trigger1 = animelemtime(4)=0
time = 0

[State 1401, PSND]
type = playsnd
trigger1 = time = 0
value = 1400,0
channel = 0

[State 1401, PSND]
type = playsnd
trigger1 = time = 0
value = 2000,10
channel = 4

[State 1401, VS]
type = velset
trigger1 = anim = 100
x = 6.0

[State 1401, CA]
type = changeanim
triggerall = anim = 100
trigger1 = var(10)<=1 && time>=6
trigger2 = var(10)=2 && time>=18
trigger3 = var(10)>=3 && time>=28
trigger4 = time>=6 && p2bodydist x <= 40
value = 1401

[State 1401, CA]
type = changeanim
triggerall = anim = 1401
trigger1 = var(13)>=70 && animelemtime(10)=0
trigger2 = var(13)>=30 && animelemtime(11)=0
value = 1401
elem = 12

[State 1401, Velset]
type = statetypeset
trigger1 = anim = 1401
trigger1 = animelemtime(3)=0
physics = N

[State 1401, Velset]
type = velset
trigger1 = anim = 1401
trigger1 = animelemtime(3)=0
x = -10.0+2.5*(var(13)=[30,69])+5.0*(var(13)>=70);-1.0*(var(10)=2)-2.0*(var(10)>=3)

[State 1401, Velset]
type = veladd
trigger1 = anim = 1401
trigger1 = animelemtime(3)>0
trigger1 = vel x < 0
x = 0.5

[State 1401, PSND]
type = playsnd
trigger1 = anim = 1401
trigger1 = animelemtime(3)=0
value = 210,0
channel = 0

[State 1401, PSND]
type = playsnd
trigger1 = anim = 1401
trigger1 = animelemtime(3)=0
value = 1400,10
channel = 4

[State 0, Helper]
type = Helper
triggerall = anim = 1401
trigger1 = animelemtime(3)=0
helpertype = normal ;player
name = "Blast"
ID = 21400
stateno = 21400
pos = 30,-70
postype = p1 ;p2,front,back,left,right
facing = 1
keyctrl = 0
ownpal = 1
supermovetime = 0
pausemovetime = 0

[State -2, REX]
type = RemoveExplod
triggerall = anim = 1401
trigger1 = animelemtime(12)=0
id = 21400

[State 1401, Damage Set]
type = null
trigger1 = time = 0
trigger1 = (var(6):=(var(18)+floor(var(18)*0.5)*(var(13)>=30)+floor(var(18)*0.5)*(var(13)>=70)))||1
trigger1 = (var(7):=(ceil(var(18)*0.2)+ceil(var(18)*0.5*0.2)*(var(13)>=30)+ceil(var(18)*0.5*0.2)*(var(13)>=70)))||1

[State 1101, Hitdef]
type = HitDef
trigger1 = ifelse((var(34)&floor(exp(6*ln(2)) + 0.5)),0,1)
trigger1 = anim = 1401
trigger1 = animelemtime(3)>=0 && animelemtime(4)<0
trigger1 = !movecontact && !movereversed
;trigger1 = var(17)=0
attr = S,SA
damage = ceil(var(6)*fvar(11)*ifelse(var(42),1.25,1.0)),var(7)                   ;Damage that move inflicts, guard damage
animtype = Heavy
guardflag = M
hitflag = MAF
priority = 4,Hit
pausetime = 10,10
sparkno = S8020+(random%2)
guard.sparkno = S8030
sparkxy = -20,-60
hitsound = s1,2
guardsound = s2,0
ground.type = High
ground.slidetime = 24+3*(var(42))
ground.hittime = 24+3*(var(42))
air.hittime = 24+3*(var(42))
guard.slidetime = 18
guard.hittime = 18
ground.velocity = -10.5,-7.0
air.type = High
air.velocity = -10.5,-7.0
getpower = 80,80
givepower = 40,40
ground.cornerpush.veloff = 0
guard.cornerpush.veloff = 0
air.cornerpush.veloff = 0
yaccel = 0.5
fall = 1
air.fall = 1
fall.recover = cond((var(13)>=70)||var(10)>=3,0,1);1
fall.recovertime = cond((var(13)>=70)||var(10)>=3,999999,120)
p2facing = 1
id = 1400

[State 0, Hard Knockdown]
type = TargetState
trigger1 = (var(13)>=30) && (var(13)<70) && var(10)<=2
trigger1 = p2statetype= A && (movehit = 1) && (p2stateno!=[6020,6110])
value =6020
ID = 1400
ignorehitpause =1

[State 0, Wallbounce]
type = TargetState
trigger1 = (var(13)>=70) || var(10)>=3
trigger1 = p2statetype= A && (movehit = 1) && (p2stateno!=[6020,6110])
value =260;6020
ID = 1400
ignorehitpause =1

[State 200, Damage Dampen]
type = varset
trigger1 = movehit
fvar(10) = fvar(10)*0.80*cond(var(13)<70 && var(10)<3,1.0,0.85)*cond(fvar(10)>=1.0,(fvar(30)),1.0)
ignorehitpause = 1
persistent = 0

[State -2, FLAG RECOVERY FRAMES]
type = statetypeset
trigger1 = anim=1401
trigger1 = animelemtime(4)=0
trigger2 = movecontact||movereversed
movetype = I
ignorehitpause = 1
persistent = 0

[State 1000, CS]
type = ChangeState
trigger1 = anim = 1401
trigger1 = animtime = 0
value = 0
ctrl = 1

;---------------------------------------------------------------------------
; Radiant Blade Blast
[Statedef 21400]
type = A
movetype = I
physics = N
velset = 0,0
anim = 21400
sprpriority = 5
ctrl = 0

[State 21400, BTR]
type = bindtoroot
trigger1 = 1
pos = 44,-67

[State 1108, AssertSpecial]
type = AssertSpecial
trigger1 = 1
flag = noshadow
ignorehitpause = 1

[State 1108, Trans]
type = Trans
trigger1 = 1
trans = addalpha
alpha = 256,256
ignorehitpause = 1

[State 0, AngleDraw]
type = AngleDraw
trigger1 = 1
scale = 0.75-cond(var(0)<11,0,(0.75*(var(0)-11)/10.0)),0.75-cond(var(0)<11,0,(0.75*(var(0)-11)/10.0))
ignorehitpause = 1

[State 21400, Zeeky]
type = destroyself
trigger1 = root,stateno != 1401
trigger2 = var(0)>=21

[State 21400, Timer]
type = varadd
trigger1 = root,hitpausetime=0
var(0) = 1

;---------------------------------------------------------------------------
; Guard Cancel Counter
[Statedef 1900]
type = U
movetype = A
physics = N
velset = 0,0
;anim = 1900
poweradd = 0
ctrl = 0
sprpriority = 1
;facep2 = 1

[State 2000, NotHitBy]
type = NotHitBy
trigger1 = time=0
value = SCA,AA,AP,AT
time = 40
;ignorehitpause = 
;persistent = 

[State 2000, Spellcard Effect]
type = helper
trigger1 = time = 0
helpertype = normal
name = "Spellcard_FX"
id = 21900;1999
stateno = 21900;1999
pos = 0,-50
postype = p1
ownpal = 1
facing = 1
pausemovetime = 40
supermovetime = 40

[state 1010, Za Warudo!]
type = SuperPause
trigger1 = time = 0
time = 20;0
anim = -1
sound = S4,3
p2defmul = 1
poweradd = -1000
unhittable = 1
movetime = 20;30
darken = 0

[State 1900, CS]
type = changestate
trigger1 = time>=20
trigger1 = (var(10):=2)||1
trigger1 = (var(46):=1)||1
value = 1300

;-----------------------
; Guard Cancel Use Effect
[Statedef 21900]
anim = 1999
velset = 0,0
sprpriority = 3

[State 2000, No Shadow]
type = assertspecial
trigger1 = 1
flag = noshadow
ignorehitpause = 1

[State 1999, Angleset]
type = angleadd
trigger1 = 1
value = -10

[State 1999, Varadd]
type = varadd
trigger1 = time <= 20
var(0) = 1

[State 1999, Angledraw]
type = angledraw
trigger1 = 1
scale = 0.5+0.15*var(0),0.5+0.15*var(0)

[State 700, T]
type = trans
trigger1 = 1
trans = addalpha
alpha = 256-ifelse(time<30,0,floor(256.0*(time-30)/40.0)),256

[State 700, Zeeky]
type = destroyself
trigger1 = time >= 70